<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Prints an instance of mod_activitycluster.
 *
 * @package     mod_activitycluster
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require(__DIR__.'/../../config.php');
require_once(__DIR__.'/lib.php');
require_once('cluster_form.php');

// Course_module ID.
$id = optional_param('id', 0, PARAM_INT);
$cmid = optional_param('cmid', 0, PARAM_INT);
$process = optional_param('process', 0, PARAM_INT);

if ($cmid) {
    $cm = get_coursemodule_from_id('nedactivitycluster', $cmid, 0, false, MUST_EXIST);
    $course = $DB->get_record('course', array('id' => $cm->course), '*', MUST_EXIST);
    $instance = $DB->get_record('nedactivitycluster', array('id' => $cm->instance), '*', MUST_EXIST);
} else {
    throw new \moodle_exception(get_string('missingidandcmid', 'nedactivitycluster'));
}

require_login($course, true, $cm);

$modulecontext = context_module::instance($cm->id);

require_capability('mod/nedactivitycluster:addinstance', $modulecontext);

$thispageurl = new moodle_url('/mod/nedactivitycluster/cluster_delete.php', array('id' => $id, 'cmid' => $cmid));
$returnurl = new moodle_url('/mod/nedactivitycluster/view.php', array('id' => $cmid));

$PAGE->set_url($thispageurl);
$PAGE->set_pagelayout('course');
$PAGE->set_context($modulecontext);

$title = get_string('delete', 'nedactivitycluster');
$heading = $SITE->fullname;
$PAGE->set_title($heading);
$PAGE->set_heading($heading);

// Breadcrumb.
$PAGE->navbar->add($title);

$nedactivitycluster = $DB->get_record('nedactivitycluster_clusters', array('id' => $id), '*', MUST_EXIST);

if ($process) {
    require_sesskey();
    $DB->delete_records('nedactivitycluster_clusters', array('id' => $id));
    redirect($returnurl);
    die;
} else {
    echo $OUTPUT->header();
    echo html_writer::tag('h1', $title, array('class' => 'page-title'));
    echo $OUTPUT->confirm(
        '<div><strong>'.get_string('name', 'nedactivitycluster').': </strong>'.$nedactivitycluster->name.'<br><br></div>'.
        get_string('deleteconfirmmsg', 'nedactivitycluster'),
        new moodle_url('/mod/nedactivitycluster/cluster_delete.php', array('id' => $id, 'cmid' => $cmid, 'process' => 1)),
        $returnurl
    );
    echo $OUTPUT->footer();
}