<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Prints an instance of mod_nedactivitycluster.
 *
 * @package     mod_nedactivitycluster
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/mod/nedactivitycluster/lib.php');
require_once('cluster_form.php');

// Course_module ID.
$id = optional_param('id', 0, PARAM_INT);
$cmid = optional_param('cmid', 0, PARAM_INT);
$instance = null;

if ($cmid) {
    $cm = get_coursemodule_from_id('nedactivitycluster', $cmid, 0, false, MUST_EXIST);
    $course = $DB->get_record('course', array('id' => $cm->course), '*', MUST_EXIST);
    $instance = $DB->get_record('nedactivitycluster', array('id' => $cm->instance), '*', MUST_EXIST);
} else {
    throw new \moodle_exception('missingidandcmid', 'nedactivitycluster');
}

require_login($course, true, $cm);

$modulecontext = context_module::instance($cm->id);

require_capability('mod/nedactivitycluster:addinstance', $modulecontext);


$thispageurl = new moodle_url('/mod/nedactivitycluster/cluster_edit.php', array('id' => $id, 'cmid' => $cmid));
$returnurl = new moodle_url('/mod/nedactivitycluster/view.php', array('id' => $cmid));

$PAGE->set_url($thispageurl);
$PAGE->set_pagelayout('course');
$PAGE->set_context($modulecontext);

$name = get_string('addedit', 'nedactivitycluster');
$title = get_string('addedit', 'nedactivitycluster');
$heading = $SITE->fullname;

// Breadcrumb.
$PAGE->navbar->add($name);

$PAGE->set_title($title);
$PAGE->set_heading($heading);
$PAGE->requires->js_call_amd('mod_nedactivitycluster/cluster_form', 'init');

$mform = new cluster_form(null, array('courseid' => $course->id));

if ($id) {
    $toform = $DB->get_record('nedactivitycluster_clusters', array('id' => $id), '*', MUST_EXIST);
    $mods = explode(',', $toform->sequence);
    foreach ($mods as $_cmid) {
        $toform->{'activity'.$_cmid} = $_cmid;
    }
    // Description.
    $summary = [];
    $summary['text'] = $toform->summary;
    $summary['format'] = $toform->summaryformat;
    $toform->summary = $summary;
}

if ($mform->is_cancelled()) {
    redirect($returnurl);
} else if ($fromform = $mform->get_data()) {
    $rec = new stdClass();
    $rec->name = $fromform->name;
    $rec->summary = $fromform->summary['text'];
    $rec->summaryformat = $fromform->summary['format'];
    $rec->sequence = nedactivitycluster_get_sequence_from_form($fromform);

    if ($id) {
        // UPDATE.
        $rec->id = $id;
        $rec->timemodified = time();
        $DB->update_record('nedactivitycluster_clusters', $rec);
    } else {
        // INSERT.
        $rec->nedactivitycluster = $instance->id;
        $rec->timemodified = time();
        $rec->section = nedactivitycluster_get_next_section($instance->id);
        $rec->id = $DB->insert_record('nedactivitycluster_clusters', $rec);
    }
    redirect($returnurl);
    exit;
}

echo $OUTPUT->header();
if ($id) {
    $toform->cmid = $cmid;
} else {
    $toform = new stdClass();
    $toform->cmid = $cmid;
}
$mform->set_data($toform);
$mform->display();
echo $OUTPUT->footer();