<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The main mod_nedactivitycluster configuration form.
 *
 * @package     mod_nedactivitycluster
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/course/moodleform_mod.php');

/**
 * Module instance settings form.
 *
 * @package    mod_nedactivitycluster
 * @copyright  2018 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class mod_nedactivitycluster_mod_form extends moodleform_mod {

    /**
     * Defines forms elements
     */
    public function definition() {
        global $CFG;

        $mform = $this->_form;

        // Adding the "general" fieldset, where all the common settings are showed.
        $mform->addElement('header', 'general', get_string('general', 'form'));

        // Adding the standard "name" field.
        $mform->addElement('text', 'name', get_string('name', 'mod_nedactivitycluster'), array('size' => '64'));

        if (!empty($CFG->formatstringstriptags)) {
            $mform->setType('name', PARAM_TEXT);
        } else {
            $mform->setType('name', PARAM_CLEANHTML);
        }

        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');

        // Adding the standard "intro" and "introformat" fields.
        if ($CFG->branch >= 29) {
            $this->standard_intro_elements();
        } else {
            $this->standard_intro_elements();
        }

        // Adding the rest of mod_nedactivitycluster settings.
        $mform->addElement('header', 'nedactivityclustersettings', get_string('settings', 'mod_nedactivitycluster'));

        $mform->addElement('advcheckbox', 'showtitleheader', '', get_string('showtitleheader', 'mod_nedactivitycluster'), array('group' => 1), array(0, 1));
        $mform->setDefault('showtitleheader', 1);

        $mform->addElement('advcheckbox', 'showactivitytypecolumn', '', get_string('showactivitytypecolumn', 'mod_nedactivitycluster'), array('group' => 2), array(0, 1));
        $mform->setDefault('showactivitytypecolumn', 1);

        $mform->addElement('advcheckbox', 'showpassfailbackgroundcolors', '', get_string('showpassfailbackgroundcolors', 'mod_nedactivitycluster'), array('group' => 3), array(0, 1));
        $mform->setDefault('showpassfailbackgroundcolors', 1);

        $mform->addElement('advcheckbox', 'showstudentmenu', '', get_string('showstudentmenu', 'mod_nedactivitycluster'), array('group' => 4), array(0, 1));
        $mform->setDefault('showstudentmenu', 1);

        $mform->addElement('advcheckbox', 'showgrade', '', get_string('showgrade', 'mod_nedactivitycluster'), array('group' => 5), array(0, 1));
        $mform->setDefault('showgrade', 1);

        // Adding the rest of mod_nedactivitycluster settings.
        $mform->addElement('header', 'questionnaireintegration', get_string('questionnaireintegration', 'mod_nedactivitycluster'));

        $mform->addElement('selectyesno', 'pulldatafromquestionnaire', get_string('pulldatafromquestionnaire', 'mod_nedactivitycluster'));
        $mform->setDefault('pulldatafromquestionnaire', 0);

        $mform->addElement('text', 'questionnairequestionname', get_string('questionnairequestionname', 'mod_nedactivitycluster'));
        $mform->setType('questionnairequestionname', PARAM_TEXT);

        $mform->addElement('text', 'questionnametoshow', get_string('questionnametoshow', 'mod_nedactivitycluster'));
        $mform->setType('questionnametoshow', PARAM_TEXT);

        $mform->addElement('selectyesno', 'calculatetotal', get_string('calculatetotal', 'mod_nedactivitycluster'));
        $mform->setDefault('calculatetotal', 0);

        $mform->addElement('selectyesno', 'calculatetargettotal', get_string('calculatetargettotal', 'mod_nedactivitycluster'));
        $mform->setDefault('calculatetargettotal', 0);

        // Add standard elements.
        $this->standard_coursemodule_elements();

        // Add standard buttons.
        $this->add_action_buttons();
    }

    /**
     * Add elements for setting the custom completion rules.
     *
     * @category completion
     * @return array List of added element names, or names of wrapping group elements.
     */
    public function add_completion_rules() {

        $mform = $this->_form;

        $group = [
            $mform->createElement('checkbox', 'allactivitiesmustbecompleted', ' ', get_string('allactivitiesmustbecompleted', 'mod_nedactivitycluster')),
        ];
        $mform->addGroup($group, 'completiongroup', '', [' '], false);

        return ['completiongroup'];
    }

    /**
     * Called during validation to see whether some module-specific completion rules are selected.
     *
     * @param array $data Input data not yet validated.
     * @return bool True if one or more rules is enabled, false if none are.
     */
    public function completion_rule_enabled($data) {
        return (!empty($data['allactivitiesmustbecompleted']));
    }

    function get_data() {
        $data = parent::get_data();
        if (!$data) {
            return $data;
        }
        if (!empty($data->completionunlocked)) {
            // Turn off completion settings if the checkboxes aren't ticked
            $autocompletion = !empty($data->completion) && $data->completion==COMPLETION_TRACKING_AUTOMATIC;
            if (empty($data->allactivitiesmustbecompleted) || !$autocompletion) {
                $data->allactivitiesmustbecompleted = 0;
            }
        }
        return $data;
    }

}
