<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Prints an instance of mod_nedactivitycluster.
 *
 * @package     mod_nedactivitycluster
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot.'/mod/nedactivitycluster/lib.php');
require_once($CFG->dirroot.'/group/lib.php');
require_once($CFG->dirroot.'/lib/filelib.php');

// Course_module ID.
$id = optional_param('id', 0, PARAM_INT);
$group = optional_param('group', 0, PARAM_INT);
$u = optional_param('u', 0, PARAM_INT);
$instance = null;

if ($id) {
    $cm = get_coursemodule_from_id('nedactivitycluster', $id, 0, false, MUST_EXIST);
    $course = $DB->get_record('course', array('id' => $cm->course), '*', MUST_EXIST);
    $instance = $DB->get_record('nedactivitycluster', array('id' => $cm->instance), '*', MUST_EXIST);
    $modulecontext = context_module::instance($cm->id);
    $instance->intro = file_rewrite_pluginfile_urls($instance->intro, 'pluginfile.php',
        $modulecontext->id, 'mod_nedactivitycluster', 'intro', null);

} else {
    throw new \moodle_exception('missingidandcmid', 'nedactivitycluster');
}

require_login($course, true, $cm);

$params = new stdClass();
$params->canview = has_capability('mod/nedactivitycluster:view', $modulecontext);
$params->canedit = has_capability('mod/nedactivitycluster:addinstance', $modulecontext);
$params->viewstudentprogress = has_capability('mod/nedactivitycluster:viewstudentprogress', $modulecontext);
$params->group = $group;
$params->u = $u;

// $group = groups_get_activity_group($cm, true); print_object($group);die;

$event = \mod_nedactivitycluster\event\course_module_viewed::create(array(
    'objectid' => $instance->id,
    'context' => $modulecontext
));
$event->trigger();


$PAGE->set_url('/mod/nedactivitycluster/view.php', array('id' => $cm->id));
$PAGE->set_title(format_string($instance->name));
$PAGE->set_heading(format_string($course->fullname));
$PAGE->set_pagelayout('course');
$PAGE->set_context($modulecontext);

$PAGE->requires->strings_for_js(array('pluginname','move_item'), 'nedactivitycluster');
$PAGE->requires->yui_module('moodle-mod_nedactivitycluster-dragdrop', 'M.mod_nedactivitycluster.init_dragdrop',
    array(array('cmid' => $cm->id)));
$PAGE->requires->js_amd_inline("
require(['jquery'], function($) {
    $('body').on('updatefailed', '[data-inplaceeditable]', function(e) {
        var exception = e.exception; // The exception object returned by the callback.
        var newvalue = e.newvalue; // The value that user tried to udpated the element to.
        e.preventDefault(); // This will prevent default error dialogue.
        // Do your own error processing here.
    });
    $('body').on('updated', '[data-inplaceeditable]', function(e) {
        var ajaxreturn = e.ajaxreturn; // Everything that web service returned.
        var oldvalue = e.oldvalue; // Element value before editing (note, this is raw value and not display value).
        // Do your own stuff, for example update all other occurences of this element on the page.
    });
});
");

echo $OUTPUT->header();
$view = new mod_nedactivitycluster\output\view($instance, (isset($u))?$u:$USER->id, $cm->id, $params);
$output = $PAGE->get_renderer('mod_nedactivitycluster');
echo $output->render($view);
echo $OUTPUT->footer();