<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains the capabilities used by the lti module
 *
 * @package qtype_lti
 * @copyright 2009 Marc Alier, Jordi Piguillem, Nikolas Galanis, marc.alier@upc.edu
 * @copyright 2009 Universitat Politecnica de Catalunya http://www.upc.edu
 * @author Marc Alier
 * @author Jordi Piguillem
 * @author Nikolas Galanis
 * @author Chris Scribner
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

$capabilities = array(

    // Whether the user can see the link to the external tool and follow it.
    'qtype/lti:view' => array('captype' => 'read', 'contextlevel' => CONTEXT_MODULE,
        'archetypes' => array('student' => CAP_ALLOW, 'teacher' => CAP_ALLOW,
        'editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW)),

    // Add an External tool activity to a course.
    'qtype/lti:addinstance' => array('riskbitmask' => RISK_XSS,
    'captype' => 'write', 'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array('editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW),
        'clonepermissionsfrom' => 'moodle/course:manageactivities'),

    // When the user arrives at the external tool, if they have this capability
    // in Moodle, then they are given the Instructor role in the remote system,
    // otherwise they are given Learner. See the lti_get_ims_role function.
    'qtype/lti:manage' => array('riskbitmask' => RISK_PERSONAL, // A bit of a guess, but seems likely.

    'captype' => 'write', 'contextlevel' => CONTEXT_MODULE,
        'archetypes' => array('teacher' => CAP_ALLOW, 'editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW)),

    // When the user arrives at the external tool, if they have this capability
    // in Moodle, then they are given the Administrator role in the remote system,
    // otherwise they are given Learner. See the lti_get_ims_role function.
    'qtype/lti:admin' => array('riskbitmask' => RISK_PERSONAL, // A bit of a guess, but seems likely.

    'captype' => 'write', 'contextlevel' => CONTEXT_MODULE),

    // The ability to create or edit tool configurations for particular courses.
    'qtype/lti:addcoursetool' => array('captype' => 'write', 'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array('editingteacher' => CAP_PREVENT, 'manager' => CAP_PREVENT)),
    // The ability to regrade LTI questions.
    'qtype/lti:regradelti' => array('captype' => 'write', 'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array('editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW)),
    // The ability to backup qtype LTI courses via CodeExpert.
    'qtype/lti:backupcourse' => array('riskbitmask' => RISK_CONFIG | RISK_SPAM | RISK_PERSONAL | RISK_XSS, 'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array('editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW)),
    // The ability to add a globally preconfigured instance to the course.
    'qtype/lti:addgloballypreconfigedtoolinstance' => array('captype' => 'write', 'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array('editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW)),
    'qtype/lti:adddefaultinstance' => array('captype' => 'write', 'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array('editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW)),

    // The ability to request the administrator to configure a particular
    // External tool globally.
    'qtype/lti:requesttooladd' => array('captype' => 'write', 'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array('editingteacher' => CAP_ALLOW, 'manager' => CAP_ALLOW)));
