<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains the script used to register a new external tool.
 *
 * It is used to create a new form used to configure the capabilities
 * and services to be offered to the tool provider.
 *
 * @package qtype_lti
 * @copyright  2019 ETH Zurich
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once('../../../config.php');
require_once($CFG->libdir.'/adminlib.php');
require_once($CFG->dirroot.'/question/type/lti/edit_form.php');
require_once($CFG->dirroot.'/question/type/lti/locallib.php');

$action       = optional_param('action', '', PARAM_ALPHANUMEXT);
$id           = optional_param('id', '', PARAM_INT);
$tab          = optional_param('tab', '', PARAM_ALPHAEXT);
$returnto     = optional_param('returnto', '', PARAM_ALPHA);

if ($returnto == 'toolconfigure') {
    $returnurl = new moodle_url($CFG->wwwroot . '/question/type/lti/toolconfigure.php');
}

// No guest autologin.
require_login(0, false);

require_sesskey();

// Check this is for a tool created from a tool proxy.
$err = empty($id);
if (!$err) {
    $type = qtype_lti_get_type_type_config($id);
    $err = empty($type->toolproxyid);
}
if ($err) {
    $params = array('action' => $action, 'id' => $id, 'sesskey' => sesskey(), 'tab' => $tab);
    if (!empty($returnto)) {
        $params['returnto'] = $returnto;
    }
    $redirect = new moodle_url('/question/type/lti/typessettings.php', $params);
    redirect($redirect);
}

$pageurl = new moodle_url('/question/type/lti/toolssettings.php');
if (!empty($id)) {
    $pageurl->param('id', $id);
}
if (!empty($returnto)) {
    $pageurl->param('returnto', $returnto);
}
$PAGE->set_url($pageurl);

admin_externalpage_setup('manageqtypes'); // Hacky solution for printing the admin page.

$redirect = "$CFG->wwwroot/$CFG->admin/settings.php?section=qtypesettinglti&tab={$tab}";
if (!empty($returnurl)) {
    $redirect = $returnurl;
}

if ($action == 'accept') {
    qtype_lti_set_state_for_type($id, QTYPE_LTI_TOOL_STATE_CONFIGURED);
    redirect($redirect);
} else if (($action == 'reject') || ($action == 'delete')) {
    qtype_lti_set_state_for_type($id, QTYPE_LTI_TOOL_STATE_REJECTED);
    redirect($redirect);
}

if (qtype_lti_request_is_using_ssl() && !empty($type->lti_secureicon)) {
    $type->oldicon = $type->lti_secureicon;
} else {
    $type->oldicon = $type->lti_icon;
}

$form = new qtype_lti_edit_types_form($pageurl, (object)array('isadmin' => true, 'istool' => true));

if ($data = $form->get_data()) {
    $type = new stdClass();
    if (!empty($id)) {
        $type->id = $id;
        qtype_lti_update_type($type, $data);
    } else {
        $type->state = QTYPE_LTI_TOOL_STATE_CONFIGURED;
        qtype_lti_add_type($type, $data);
    }
    redirect($redirect);
} else if ($form->is_cancelled()) {
    redirect($redirect);
}

$PAGE->set_title(format_string($SITE->shortname) . ': ' . get_string('toolsetup', 'qtype_lti'));
$PAGE->navbar->add(get_string('lti_administration', 'qtype_lti'),
                $CFG->wwwroot.'/'.$CFG->admin.'/settings.php?section=qtypesettinglti');

echo $OUTPUT->header();
echo $OUTPUT->heading(get_string('toolsetup', 'qtype_lti'));
echo $OUTPUT->box_start('generalbox');

if ($action == 'update') {
    $form->set_data($type);
}

$form->display();
echo $OUTPUT->box_end();
echo $OUTPUT->footer();
