<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Scheduled task
 *
 * @package     report_ghs
 * @copyright   20 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace report_ghs\task;

use block_ned_teacher_tools\deadline_manager;
use cache;
use report_ghs\helper;
use report_ghs\onedrivetoken;

defined('MOODLE_INTERNAL') || die();

/**
 * Class update_reports
 * @package report_ghs\task
 */
class sync_enrol_dates extends \core\task\scheduled_task {

    /**
     * @return string
     * @throws \coding_exception
     */
    public function get_name() {
        return get_string('syncenroldates', 'report_ghs');
    }

    /**
     * @return bool
     * @throws \dml_exception
     * @throws \moodle_exception
     */
    public function execute() {
        global $DB;

        if (!$syncdmenddateswithenrolment = get_config('block_ned_teacher_tools', 'syncdmenddateswithenrolment')) {
            return true;
        }

        $cache = cache::make('report_ghs', 'group');
        $cfg = [];

        $sql = "SELECT g.id, g.courseid, g.startdate, g.enddate
                  FROM {groups} g WHERE g.schedule = ? AND g.enddate > 0";

        $rs = $DB->get_recordset_sql($sql, [deadline_manager::SCHEDULE_FULL]);

        foreach ($rs as $group) {
            if (isset($cfg[$group->courseid])) {
                $blockcfg = $cfg[$group->courseid];
            } else {
                $blockcfg = block_ned_teacher_tools_get_block_config($group->courseid);
            }
            if (!$blockcfg) {
                continue;
            }
            if ($cachedgroup = $cache->get($group->id)) {
                if ($cachedgroup->enddate == $group->enddate) {
                    continue;
                }
            }
            deadline_manager::sync_group_enrollments($group, $blockcfg->enrolmentenddaterole, $blockcfg->setenrolmentenddayduration);
            $cache->set($group->id, $group);
        }

        $rs->close();

        return true;
    }
}