<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Scheduled task
 *
 * @package     report_ghs
 * @copyright   2019 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace report_ghs\task;

use report_ghs\helper;

defined('MOODLE_INTERNAL') || die();

/**
 * Class update_reports
 * @package report_ghs\task
 */
class update_gtm_report extends \core\task\scheduled_task {

    /**
     * @return string
     */
    public function get_name() {
        return get_string('updategtmreport', 'report_ghs');
    }

    /**
     * @return bool
     */
    public function execute() {
        adhoc_ghs_grading_time_monitor_report::update_report();
    }
}
