<?php
/**
 * @package    report_ghs
 * @subpackage NED
 * @copyright  2024 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * All upgrades checks from Moodle 3
 *
 * @param int $oldversion
 */
function report_ghs_moodle3_upgrades($oldversion): void{
    global $DB;
    $dbman = $DB->get_manager();

    if ($oldversion < 2019110704) {

        // Define table report_ghs_activity to be created.
        $table = new xmldb_table('report_ghs_activity');

        // Adding fields to table report_ghs_activity.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('cmid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('module', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('instance', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('activityname', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('numberofdays', XMLDB_TYPE_INTEGER, '9', null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_activity.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_activity.
        $table->add_index('mdl_repoghsact_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghsact_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);

        // Conditionally launch create table for report_ghs_activity.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019110704, 'report', 'ghs');
    }

    if ($oldversion < 2019111000) {

        // Define field grader to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('grader', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'activityname');

        // Conditionally launch add field grader.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019111000, 'report', 'ghs');
    }

    if ($oldversion < 2019111101) {

        // Define field userstatus to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('userstatus', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'userid');

        // Conditionally launch add field userstatus.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019111101, 'report', 'ghs');
    }

    if ($oldversion < 2019112900) {

        // Define field chortid to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('chortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'courseid');

        // Conditionally launch add field chortid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field activitytag to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('activitytag', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'grader');

        // Conditionally launch add field activitytag.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019112900, 'report', 'ghs');
    }

    if ($oldversion < 2019112902) {

        // Define field chortid to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('duedate', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'numberofdays');

        // Conditionally launch add field chortid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field activitytag to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('timesubmission', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'duedate');

        // Conditionally launch add field activitytag.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }


        // Define field activitytag to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('timegraded', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'timesubmission');

        // Conditionally launch add field activitytag.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019112902, 'report', 'ghs');
    }

    if ($oldversion < 2019120300) {

        // Define field graderid to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('graderid', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'activityname');

        // Conditionally launch add field chortid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019120300, 'report', 'ghs');
    }

    if ($oldversion < 2019120301) {

        // Define field grader to be dropped from report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('grader');

        // Conditionally launch drop field grader.
        if ($dbman->field_exists($table, $field)) {
            $dbman->drop_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019120301, 'report', 'ghs');
    }

    if ($oldversion < 2019120302) {

        // Define field graderid to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_kica');
        $field = new xmldb_field('graderid', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'groupid');

        // Conditionally launch add field chortid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019120302, 'report', 'ghs');
    }

    if ($oldversion < 2019120400) {

        // Define field ctid to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('ctid', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'graderid');

        // Conditionally launch add field chortid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019120400, 'report', 'ghs');
    }

    if ($oldversion < 2019121500) {

        // Define field timegraded to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('timegradedkica', XMLDB_TYPE_INTEGER, '18', null, null, null, '0', 'timegraded');
        // Conditionally launch add field timegraded.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Rename field timegraded on table report_ghs_activity to timegradedmoodle.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('timegraded', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'timesubmission');
        // Launch rename field timegraded.
        $dbman->rename_field($table, $field, 'timegradedmoodle');



        // Define field timegraded to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('numberofdayskica', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'numberofdays');
        // Conditionally launch add field numberofdays.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Rename field numberofdays on table report_ghs_activity to numberofdaysmoodle.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('numberofdays', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'activitytag');
        // Launch rename field numberofdays.
        $dbman->rename_field($table, $field, 'numberofdaysmoodle');

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019121500, 'report', 'ghs');
    }

    if ($oldversion < 2019123100) {

        // Define table report_ghs_group_enrollment to be created.
        $table = new xmldb_table('report_ghs_group_enrollment');

        // Adding fields to table report_ghs_group_enrollment.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('activestudents', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('suspendedstudents', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('ctid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('otid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('dmstatus', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('dmdateconflicts', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('enrolldateconflicts', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_group_enrollment.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Conditionally launch create table for report_ghs_group_enrollment.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2019123100, 'report', 'ghs');
    }

    if ($oldversion < 2020010201) {

        // Define field subject to be added to report_ghs_group_enrollment.
        $table = new xmldb_table('report_ghs_group_enrollment');

        $field = new xmldb_field('subject', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'enrolldateconflicts');

        // Conditionally launch add field subject.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('grade', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'subject');

        // Conditionally launch add field grade.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('department', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'grade');

        // Conditionally launch add field department.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('moe_code', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'department');

        // Conditionally launch add field moe_code.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('moe_name', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'moe_code');

        // Conditionally launch add field moe_name.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020010201, 'report', 'ghs');
    }

    if ($oldversion < 2020011101) {

        // Define table report_ghs_enrollment to be created.
        $table = new xmldb_table('report_ghs_enrollment');

        // Adding fields to table report_ghs_enrollment.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('cohortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('timestart', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('timeend', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courserole', XMLDB_TYPE_INTEGER, '9', null, null, null, null);
        $table->add_field('oen', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('defaultrole', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('graduation', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('program', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('registered', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_enrollment.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_enrollment.
        $table->add_index('mdl_repoghskica_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghskica_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);

        // Conditionally launch create table for report_ghs_enrollment.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020011101, 'report', 'ghs');
    }

    if ($oldversion < 2020011600) {

        // Define field instancegrade to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('instancegrade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null, 'instance');

        // Conditionally launch add field instancegrade.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020011600, 'report', 'ghs');
    }

    if ($oldversion < 2020011700) {

        // Define field kicaenabled to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('kicaenabled', XMLDB_TYPE_INTEGER, '4', null, null, null, '0', 'timegradedkica');

        // Conditionally launch add field kicaenabled.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020011700, 'report', 'ghs');
    }

    if ($oldversion < 2020011800) {

        // Define table report_ghs_kica to be renamed to report_ghs_grades.
        $table = new xmldb_table('report_ghs_kica');

        // Launch rename table for report_ghs_kica.
        $dbman->rename_table($table, 'report_ghs_grades');

        // Define table report_ghs_activity to be renamed to report_ghs_sla.
        $table = new xmldb_table('report_ghs_activity');

        // Launch rename table for report_ghs_activity.
        $dbman->rename_table($table, 'report_ghs_sla');

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020011800, 'report', 'ghs');
    }

    if ($oldversion < 2020011801) {

        // Define field frate to be added to report_ghs_grades.
        $table = new xmldb_table('report_ghs_grades');
        $field = new xmldb_field('frate', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'kica30');

        // Conditionally launch add field frate.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field srate to be added to report_ghs_grades.
        $table = new xmldb_table('report_ghs_grades');
        $field = new xmldb_field('srate', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'frate');

        // Conditionally launch add field srate.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field frate to be added to report_ghs_enrollment.
        $table = new xmldb_table('report_ghs_enrollment');
        $field = new xmldb_field('frate', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'registered');

        // Conditionally launch add field frate.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field srate to be added to report_ghs_enrollment.
        $table = new xmldb_table('report_ghs_enrollment');
        $field = new xmldb_field('srate', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'frate');

        // Conditionally launch add field srate.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field finalactivity to be added to report_ghs_sla.
        $table = new xmldb_table('report_ghs_sla');
        $field = new xmldb_field('finalactivity', XMLDB_TYPE_INTEGER, '4', null, null, null, '0', 'kicaenabled');

        // Conditionally launch add field finalactivity.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field slaot to be added to report_ghs_sla.
        $table = new xmldb_table('report_ghs_sla');
        $field = new xmldb_field('slaot', XMLDB_TYPE_INTEGER, '4', null, null, null, '0', 'finalactivity');

        // Conditionally launch add field slaot.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020011801, 'report', 'ghs');
    }

    if ($oldversion < 2020012300) {

        // Define field submissionstatus to be added to report_ghs_sla.
        $table = new xmldb_table('report_ghs_sla');
        $field = new xmldb_field('submissionstatus', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'slaot');

        // Conditionally launch add field submissionstatus.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020012300, 'report', 'ghs');
    }

    if ($oldversion < 2020021900) {

        // Define table report_ghs_missed_grade to be created.
        $table = new xmldb_table('report_ghs_missed_grade');

        // Adding fields to table report_ghs_missed_grade.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('chortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('ctid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('otid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('cmid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('module', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('instance', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('activityname', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('enddate', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('activitygrade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('kicagrade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('activitytag', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('skipped', XMLDB_TYPE_INTEGER, '2', null, null, null, null);
        $table->add_field('gcomp', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_missed_grade.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_missed_grade.
        $table->add_index('mdl_repoghsmiss_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghsmiss_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);

        // Conditionally launch create table for report_ghs_missed_grade.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020021900, 'report', 'ghs');
    }

    if ($oldversion < 2020022000) {

        // Rename field enddate on table report_ghs_missed_grade to duedate.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('enddate', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'activityname');

        // Launch rename field enddate.
        $dbman->rename_field($table, $field, 'duedate');

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020022000, 'report', 'ghs');
    }

    if ($oldversion < 2020022200) {

        // Define field activitygrademax to be added to report_ghs_missed_grade.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('activitygrademax', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null, 'activitygrade');

        // Conditionally launch add field activitygrademax.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field kicagrademax to be added to report_ghs_missed_grade.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('kicagrademax', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null, 'kicagrade');

        // Conditionally launch add field kicagrademax.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020022200, 'report', 'ghs');
    }

    if ($oldversion < 2020022801) {

        // Define field graded to be added to report_ghs_missed_grade.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('graded', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'gcomp');

        // Conditionally launch add field graded.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field all to be added to report_ghs_missed_grade.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('all', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'graded');

        // Conditionally launch add field all.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020022801, 'report', 'ghs');
    }

    if ($oldversion < 2020030401) {

        // Define field userstatus to be added to report_ghs_missed_grade.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('userstatus', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'userid');

        // Conditionally launch add field userstatus.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020030401, 'report', 'ghs');
    }

    if ($oldversion < 2020030402) {

        // Define field completed to be added to report_ghs_missed_grade.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('completed', XMLDB_TYPE_INTEGER, '2', null, null, null, '0', 'skipped');

        // Conditionally launch add field completed.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field excluded to be added to report_ghs_missed_grade.
        $table = new xmldb_table('report_ghs_missed_grade');
        $field = new xmldb_field('excluded', XMLDB_TYPE_INTEGER, '2', null, null, null, '0', 'completed');

        // Conditionally launch add field excluded.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }


        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020030402, 'report', 'ghs');
    }

    if ($oldversion < 2020041200) {

        // Define field gradeid to be added to report_ghs_sla.
        $table = new xmldb_table('report_ghs_sla');
        $field = new xmldb_field('gradeid', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'ctid');

        // Conditionally launch add field gradeid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020041200, 'report', 'ghs');
    }

    if ($oldversion < 2020050800) {

        // Define field cohortid to be added to report_ghs_group_enrollment.
        $table = new xmldb_table('report_ghs_group_enrollment');
        $field = new xmldb_field('cohortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null, 'groupid');

        // Conditionally launch add field cohortid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2020050800, 'report', 'ghs');
    }

    if ($oldversion < 2021033100) {

        // Define field gradingerror to be added to report_ghs_grades.
        $table = new xmldb_table('report_ghs_grades');
        $field = new xmldb_field('gradingerror', XMLDB_TYPE_INTEGER, '4', null, null, null, '0', 'srate');

        // Conditionally launch add field gradingerror.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2021033100, 'report', 'ghs');
    }

    if ($oldversion < 2022052001) {

        // Define table report_ghs_grades to be created.
        $table = new xmldb_table('report_ghs_grades');

        // Adding fields to table report_ghs_grades.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('chortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('graderid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('enrolldate', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('coursegrade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('zeros', XMLDB_TYPE_INTEGER, '9', null, null, null, null);
        $table->add_field('kicaavg', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('kica70', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('kica30', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('frate', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('srate', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('gradingerror', XMLDB_TYPE_INTEGER, '4', null, null, null, '0');
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_grades.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_grades.
        $table->add_index('mdl_repoghsgrades_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghsgrades_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);

        // Conditionally launch create table for report_ghs_grades.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2022052001, 'report', 'ghs');
    }

    if ($oldversion < 2022052302) {

        // Define table report_ghs_grades to be created.
        $table = new xmldb_table('report_ghs_grades');

        // Adding fields to table report_ghs_grades.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('chortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('graderid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('enrolldate', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('coursegrade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('zeros', XMLDB_TYPE_INTEGER, '9', null, null, null, null);
        $table->add_field('kicaavg', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('kica70', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('kica30', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('frate', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('srate', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('gradingerror', XMLDB_TYPE_INTEGER, '4', null, null, null, '0');
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_grades.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_grades.
        $table->add_index('mdl_repoghsgrades_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghsgrades_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);

        // Conditionally launch create table for report_ghs_grades.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2022052302, 'report', 'ghs');
    }

    if ($oldversion < 2022102600) {

        // Define table report_ghs_dm_overview to be created.
        $table = new xmldb_table('report_ghs_dm_overview');

        // Adding fields to table report_ghs_dm_overview.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '19', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '19', null, null, null, null);
        $table->add_field('cohortid', XMLDB_TYPE_INTEGER, '19', null, null, null, null);
        $table->add_field('ctid', XMLDB_TYPE_INTEGER, '19', null, null, null, null);
        $table->add_field('numofclassdays', XMLDB_TYPE_INTEGER, '10', null, null, null, null);
        $table->add_field('numofdmdays', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('numofsummatives', XMLDB_TYPE_INTEGER, '19', null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');

        // Adding keys to table report_ghs_dm_overview.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_dm_overview.
        $table->add_index('mdl_repoghssm_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);

        // Conditionally launch create table for report_ghs_dm_overview.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2022102600, 'report', 'ghs');
    }

    if ($oldversion < 2022110900) {

        // Define field dmcomplete to be added to report_ghs_dm_overview.
        $table = new xmldb_table('report_ghs_dm_overview');
        $field = new xmldb_field('dmcomplete', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'numofdmdays');

        // Conditionally launch add field dmcomplete.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2022110900, 'report', 'ghs');
    }

    if ($oldversion < 2023021300) {

        // Define field knowledge to be added to report_ghs_grades.
        $table = new xmldb_table('report_ghs_grades');

        $field = new xmldb_field('knowledge', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null, 'kicaavg');

        // Conditionally launch add field knowledge.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('inquiry', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null, 'knowledge');

        // Conditionally launch add field inquiry.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('communication', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null, 'inquiry');

        // Conditionally launch add field communication.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $field = new xmldb_field('application', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null, 'communication');

        // Conditionally launch add field application.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023021300, 'report', 'ghs');
    }

    if ($oldversion < 2023021400) {

        // Define table report_ghs_activity to be created.
        $table = new xmldb_table('report_ghs_activity');

        // Adding fields to table report_ghs_activity.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('cohortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('cmid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('module', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('instance', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('activityname', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('finalgrade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('knowledge', XMLDB_TYPE_NUMBER, '10, 2', null, null, null, null);
        $table->add_field('inquiry', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('communication', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('application', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_activity.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_activity.
        $table->add_index('mdl_repoghsacti_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghsacti_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);

        // Conditionally launch create table for report_ghs_activity.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023021400, 'report', 'ghs');
    }

    if ($oldversion < 2023022300) {

        // Define field knowledge to be added to report_ghs_grades.
        $table = new xmldb_table('report_ghs_grades');

        $field = new xmldb_field('lastactivity', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'srate');

        // Conditionally launch add field knowledge.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023022300, 'report', 'ghs');
    }

    if ($oldversion < 2023030102) {

        // Define field lastactivity to be added to report_ghs_activity.
        $table = new xmldb_table('report_ghs_activity');
        $field = new xmldb_field('lastactivity', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'application');

        // Conditionally launch add field lastactivity.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023030102, 'report', 'ghs');
    }

    if ($oldversion < 2023030800) {

        // Define table report_ghs_submissions to be created.
        $table = new xmldb_table('report_ghs_submissions');

        // Adding fields to table report_ghs_submissions.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '11', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('cohortid', XMLDB_TYPE_INTEGER, '11', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '11', null, null, null, null);
        $table->add_field('cmid', XMLDB_TYPE_INTEGER, '11', null, null, null, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '11', null, null, null, null);
        $table->add_field('ncgid', XMLDB_TYPE_INTEGER, '11', null, null, null, '0');
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '11', null, null, null, null);
        $table->add_field('wrongsubmission', XMLDB_TYPE_INTEGER, '2', null, null, null, null);
        $table->add_field('latesubmission', XMLDB_TYPE_INTEGER, '2', null, null, null, null);
        $table->add_field('misseddeadline', XMLDB_TYPE_INTEGER, '2', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '11', null, null, null, null);
        $table->add_field('module', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('instance', XMLDB_TYPE_INTEGER, '9', null, null, null, null);
        $table->add_field('activityname', XMLDB_TYPE_CHAR, '255', null, null, null, null);

        // Adding keys to table report_ghs_submissions.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_submissions.
        $table->add_index('mdl_locanedcontgrad_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);
        $table->add_index('mdl_locanedcontgrad_cmi_ix', XMLDB_INDEX_NOTUNIQUE, ['cmid']);
        $table->add_index('mdl_locanedcontgrad_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_locanedcontgrad_gra_ix', XMLDB_INDEX_NOTUNIQUE, ['ncgid']);

        // Conditionally launch create table for report_ghs_submissions.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023030800, 'report', 'ghs');
    }

    if ($oldversion < 2023031500) {

        // Define table report_ghs_grade_changes to be created.
        $table = new xmldb_table('report_ghs_grade_changes');

        // Adding fields to table report_ghs_grade_changes.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '18', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('cohortid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('graderid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('cmid', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('module', XMLDB_TYPE_CHAR, '100', null, null, null, null);
        $table->add_field('instance', XMLDB_TYPE_INTEGER, '18', null, null, null, null);
        $table->add_field('activityname', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('gradebefore', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('gradeafter', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('timegrade', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('timedifference', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '18', null, null, null, '0');

        // Adding keys to table report_ghs_grade_changes.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_grade_changes.
        $table->add_index('mdl_repoghschange_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghschage_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);
        $table->add_index('mdl_repoghschage_cho_ix', XMLDB_INDEX_NOTUNIQUE, ['cohortid']);
        $table->add_index('mdl_repoghschage_gro_ix', XMLDB_INDEX_NOTUNIQUE, ['groupid']);
        $table->add_index('mdl_repoghschage_cmi_ix', XMLDB_INDEX_NOTUNIQUE, ['cmid']);

        // Conditionally launch create table for report_ghs_grade_changes.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023031500, 'report', 'ghs');
    }

    if ($oldversion < 2023110601) {

        // Define table report_ghs_user_info_data to be created.
        $table = new xmldb_table('report_ghs_user_info_data');

        // Adding fields to table report_ghs_user_info_data.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('fieldid', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('data', XMLDB_TYPE_TEXT, null, null, XMLDB_NOTNULL, null, null);
        $table->add_field('dataformat', XMLDB_TYPE_INTEGER, '3', null, XMLDB_NOTNULL, null, '0');

        // Adding keys to table report_ghs_user_info_data.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);
        $table->add_key('mdl_userinfodata_usefie_uix', XMLDB_KEY_UNIQUE, ['userid', 'fieldid']);

        // Conditionally launch create table for report_ghs_user_info_data.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023110601, 'report', 'ghs');
    }

    if ($oldversion < 2023110901) {

        // Define table report_ghs_english_proficien to be created.
        $table = new xmldb_table('report_ghs_english_proficien');

        // Adding fields to table report_ghs_english_proficien.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '19', null, null, null, null);
        $table->add_field('defaultrole', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('program', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('ossltscore', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('ossltstatus', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('opt', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('esldo', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('esldo_grade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('esleo', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('esleo_grade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('eng3u', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('eng3u_grade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('eng4u', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('eng4u_grade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('olc4o', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('olc4o_grade', XMLDB_TYPE_NUMBER, '10, 5', null, null, null, null);
        $table->add_field('ossltyear', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('gradyear', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('esl', XMLDB_TYPE_CHAR, '255', null, null, null, null);

        // Adding keys to table report_ghs_english_proficien.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_english_proficien.
        $table->add_index('mdl_repoghsengpr_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);

        // Conditionally launch create table for report_ghs_english_proficien.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023110901, 'report', 'ghs');
    }

    if ($oldversion < 2023111100) {

        // Define field school to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('school', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'userid');

        // Conditionally launch add field school.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field firstname to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('firstname', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'school');

        // Conditionally launch add field firstname.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field lastname to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('lastname', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'firstname');

        // Conditionally launch add field lastname.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field oen to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('oen', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'lastname');

        // Conditionally launch add field oen.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023111100, 'report', 'ghs');
    }

    if ($oldversion < 2023120601) {

        // Define field gender to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('gender', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'esl');

        // Conditionally launch add field gender.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }


        // Define field firstlanguage to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('firstlanguage', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'gender');

        // Conditionally launch add field firstlanguage.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }


        // Define field grade to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('grade', XMLDB_TYPE_CHAR, '100', null, null, null, null, 'firstlanguage');

        // Conditionally launch add field grade.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Define field graduation to be added to report_ghs_english_proficien.
        $table = new xmldb_table('report_ghs_english_proficien');
        $field = new xmldb_field('graduation', XMLDB_TYPE_CHAR, '255', null, null, null, null, 'gradyear');

        // Conditionally launch add field graduation.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2023120601, 'report', 'ghs');
    }

    if ($oldversion < 2024031400) {

        // Define table report_ghs_class_deadlines to be created.
        $table = new xmldb_table('report_ghs_class_deadlines');

        // Adding fields to table report_ghs_class_deadlines.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('cohortid', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');
        $table->add_field('groupid', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');
        $table->add_field('cmid', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');
        $table->add_field('instance', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');
        $table->add_field('module', XMLDB_TYPE_CHAR, '50', null, null, null, '');
        $table->add_field('userid', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');
        $table->add_field('deadline', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');
        $table->add_field('deadlinetype', XMLDB_TYPE_CHAR, '255', null, null, null, null);
        $table->add_field('totalstudents', XMLDB_TYPE_INTEGER, '10', null, null, null, null);
        $table->add_field('timecreated', XMLDB_TYPE_INTEGER, '19', null, null, null, '0');

        // Adding keys to table report_ghs_class_deadlines.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_class_deadlines.
        $table->add_index('mdl_repoghsclasdead_coh_ix', XMLDB_INDEX_NOTUNIQUE, ['cohortid']);
        $table->add_index('mdl_repoghsclasdead_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);
        $table->add_index('mdl_repoghsclasdead_gro_ix', XMLDB_INDEX_NOTUNIQUE, ['groupid']);
        $table->add_index('mdl_repoghsclasdead_cmi_ix', XMLDB_INDEX_NOTUNIQUE, ['cmid']);
        $table->add_index('mdl_repoghsclasdead_ins_ix', XMLDB_INDEX_NOTUNIQUE, ['instance']);
        $table->add_index('mdl_repoghsclasdead_use_ix', XMLDB_INDEX_NOTUNIQUE, ['userid']);
        $table->add_index('mdl_repoghsclasdead_dead_ix', XMLDB_INDEX_NOTUNIQUE, ['deadline']);
        $table->add_index('mdl_repoghsclasdead_dea1_ix', XMLDB_INDEX_NOTUNIQUE, ['deadlinetype']);

        // Conditionally launch create table for report_ghs_class_deadlines.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2024031400, 'report', 'ghs');
    }

    if ($oldversion < 2024050901) {

        // Define table report_ghs_grading_time_moni to be created.
        $table = new xmldb_table('report_ghs_grading_time_moni');

        // Adding fields to table report_ghs_grading_time_moni.
        $table->add_field('id', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, XMLDB_SEQUENCE, null);
        $table->add_field('timestart', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('week', XMLDB_TYPE_INTEGER, '10', null, null, null, null);
        $table->add_field('graderid', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('courseid', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('cmid', XMLDB_TYPE_INTEGER, '19', null, XMLDB_NOTNULL, null, '0');
        $table->add_field('totaltime', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, null);

        // Adding keys to table report_ghs_grading_time_moni.
        $table->add_key('id', XMLDB_KEY_PRIMARY, ['id']);

        // Adding indexes to table report_ghs_grading_time_moni.
        $table->add_index('mdl_repoghsgradtimemoni_gra_ix', XMLDB_INDEX_NOTUNIQUE, ['graderid']);
        $table->add_index('mdl_repoghsgradtimemoni_cou_ix', XMLDB_INDEX_NOTUNIQUE, ['courseid']);
        $table->add_index('mdl_repoghsgradtimemoni_cmi_ix', XMLDB_INDEX_NOTUNIQUE, ['cmid']);
        $table->add_index('mdl_repoghsgradtimemoni_tim_ix', XMLDB_INDEX_NOTUNIQUE, ['timestart']);
        $table->add_index('mdl_repoghsgradtimemoni_wee_ix', XMLDB_INDEX_NOTUNIQUE, ['week']);

        // Conditionally launch create table for report_ghs_grading_time_moni.
        if (!$dbman->table_exists($table)) {
            $dbman->create_table($table);
        }

        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2024050901, 'report', 'ghs');
    }

    if ($oldversion < 2024052100) {

        // Define field estimatedtime to be added to report_ghs_grading_time_moni.
        $table = new xmldb_table('report_ghs_grading_time_moni');
        $field = new xmldb_field('estimatedtime', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'totaltime');


        // Conditionally launch add field estimatedtime.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Changing the default of field totaltime on table report_ghs_grading_time_moni to 0.
        $table = new xmldb_table('report_ghs_grading_time_moni');
        $field = new xmldb_field('totaltime', XMLDB_TYPE_INTEGER, '10', null, XMLDB_NOTNULL, null, '0', 'cmid');

        // Launch change of default for field totaltime.
        $dbman->change_field_default($table, $field);


        // Ghs savepoint reached.
        upgrade_plugin_savepoint(true, 2024052100, 'report', 'ghs');
    }
}
