<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Settings and links
 *
 * @package     report_ghs
 * @copyright   2019 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

global $ADMIN;
$ADMIN->add('reports',
    new admin_externalpage('reportghsgrades',
        get_string('ghsgrades', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_grades.php",
        'report/ghs:viewgrades'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsactivity',
        get_string('ghsactivity', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_sla.php",
        'report/ghs:viewsla'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsenrollment',
        get_string('ghsenrollment', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_enrollment.php",
        'report/ghs:viewenrollment'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsgroupenrollment',
        get_string('ghsgroupenrollment', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_group_enrollment.php",
        'report/ghs:viewgroupenrollment'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsmissedgrade',
        get_string('ghsmissedgrade', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_missed_grade.php",
        'report/ghs:viewgroupenrollment'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsenddateextension',
        get_string('ghsenddateextension', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_enddate_extension.php",
        'report/ghs:viewenddates'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsclassdeadlines',
        get_string('ghsclassdeadlines', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_class_deadlines.php",
        'report/ghs:viewenddates'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsactivityextension',
        get_string('ghsactivityextension', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_activity_extension.php",
        'report/ghs:viewactivityextensions'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsdmoverview',
        get_string('ghsdmoverview', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_dm_overview.php",
        'report/ghs:viewdmoverview'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsgradingtimemonitor',
        get_string('ghsgradingtimemonitor', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/ghs_grading_time_monitor.php",
        'report/ghs:uploadgroupenrollment'
    )
);
$ADMIN->add('reports',
    new admin_externalpage('reportghsimport',
        get_string('import', 'report_ghs'),
        "$CFG->wwwroot/report/ghs/import.php",
        'report/ghs:uploadgroupenrollment'
    )
);

if ($ADMIN->fulltree) {
    $pluginname = get_string('pluginname', 'report_ghs');

    $settings = new admin_settingpage('reportghs', $pluginname);

    $settings->add(
        new admin_setting_configtext(
            'report_ghs/clientid',
            new lang_string('clientid', 'report_ghs'),
            '',
            ''
        )
    );
    $settings->add(
        new admin_setting_configpasswordunmask(
            'report_ghs/clientsecret',
            new lang_string('clientsecret', 'report_ghs'),
            '',
            ''
        )
    );

    $settings->add(
        new admin_setting_configtext(
            'report_ghs/onedriveusername',
            new lang_string('username', 'report_ghs'),
            '',
            '', PARAM_RAW
        )
    );

    $settings->add(
        new admin_setting_configpasswordunmask(
            'report_ghs/onedrivepassword',
            new lang_string('password', 'report_ghs'),
            '',
            ''
        )
    );

    if ($categories = $categories = $DB->get_records_menu('course_categories', ['visible' => 1], 'sortorder')) {
        $settings->add(
            new admin_setting_configmulticheckbox(
                'report_ghs/coursecategories',
                new lang_string('coursecategories', 'report_ghs'),
                '',
                [],
                $categories
            )
        );
    }
}
