<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * GHS REPORT
 *
 * @package     report_ghs
 * @copyright   2019 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require(__DIR__ . '/../../config.php');
require_once($CFG->libdir . '/adminlib.php');

$process = optional_param('process', 0, PARAM_INT);
$report = required_param('report', PARAM_TEXT);

require_login(null, false);
$contextsystem = context_system::instance();

// Permission.
$capability = 'view'.str_replace('_', '', str_replace('ghs', '', $report));
require_capability('report/ghs:'.$capability, $contextsystem);

$thispageurl = new moodle_url('/report/ghs/update_report.php', ['report' => $report]);
$returnurl = new moodle_url('/report/ghs/update_report.php', ['report' => $report, 'process' => 0, 'data' => '']);

$PAGE->set_url($thispageurl);
$PAGE->set_context($contextsystem);

admin_externalpage_setup('reportghsgrades', null, null);

$reportcls = '\report_ghs\task\adhoc_'.$report.'_report';

if (!class_exists($reportcls)) {
    throw new coding_exception('Cannot find report class');
}

if ($task = $reportcls::get_task()) {
    echo $OUTPUT->header();
    echo html_writer::tag('div', get_string('taskwarning', 'report_ghs', userdate($task->customdata->timecreated)), array('class'=>'alert alert-info'));
    echo $OUTPUT->footer();
    die;
}

if ($process) {
    $adhoctask = new $reportcls();
    $time = time();
    $qdata = array(
        'userid' => $USER->id,
        'timecreated' => $time
    );
    $adhoctask->set_custom_data($qdata);
    $adhoctask->set_blocking(true);

    \core\task\manager::queue_adhoc_task($adhoctask, true);

    redirect(new moodle_url('/report/ghs/'.$report.'.php'), get_string('taskcreated', 'report_ghs', userdate($time)));
    die;
}

echo $OUTPUT->header();
echo $OUTPUT->confirm(
    get_string('confirmtaskschedulemsg', 'report_ghs'),
    new moodle_url('/report/ghs/update_report.php', ['report' => $report, 'process' => 1]),
    $returnurl
);
echo $OUTPUT->footer();