<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * myprofile block rendrer
 *
 * @package    theme_ned_boost
 * @copyright  2018 Mihail Geshoski <mihail@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace theme_ned_boost\output;
use block_myprofile\output\myprofile;
use plugin_renderer_base;

defined('MOODLE_INTERNAL') || die;


class block_myprofile_renderer extends plugin_renderer_base {

// myprofile block renderer
    /**
     * Return the main content for the block myprofile.
     *
     * @param myprofile $myprofile The myprofile renderable
     * @return string HTML string
     */
    public function render_myprofile(myprofile $myprofile) {
        global $USER, $OUTPUT;
        $context = $myprofile->export_for_template($this);
        $context->userpicture = $OUTPUT->user_picture($USER, ['size' => 100]);
        return $this->render_from_template('block_myprofile/myprofile', $context);
    }
}
