/**
 * JavaScript for form editing date conditions.
 *
 * @module moodle-availability_ctsubmission-form
 */
M.availability_ctsubmission = M.availability_ctsubmission || {};

/**
 * @class M.availability_ctsubmission.form
 * @extends M.core_availability.plugin
 */
M.availability_ctsubmission.form = Y.Object(M.core_availability.plugin);

/**
 * Initialises this plugin.
 *
 * Because the date fields are complex depending on Moodle calendar settings,
 * we create the HTML for these fields in PHP and pass it to this method.
 *
 * @method initInner
 * @param {Array} cms Array of objects containing cmid => name
 */
M.availability_ctsubmission.form.initInner = function(cms) {
    this.cms = cms;
};

M.availability_ctsubmission.form.getNode = function(json) {
    // Create HTML structure.
    var html = '<span class="col-form-label pr-3"> ' + M.util.get_string('title', 'availability_ctsubmission') + '</span>' +
        ' <span class="availability-group form-group"><label>' +
        '<span class="accesshide">' + M.util.get_string('label_cm', 'availability_ctsubmission') + ' </span>' +
        '<select class="custom-select" name="cm" title="' + M.util.get_string('label_cm', 'availability_ctsubmission') + '">' +
        '<option value="0">' + M.util.get_string('choosedots', 'moodle') + '</option>';
    for (var i = 0; i < this.cms.length; i++) {
        var cm = this.cms[i];
        // String has already been escaped using format_string.
        html += '<option value="' + cm.id + '">' + cm.name + '</option>';
    }
    html += '</select></label></span>';
    var node = Y.Node.create('<span class="form-inline">' + html + '</span>');

    // Set initial values.
    if (json.cm !== undefined &&
        node.one('select[name=cm] > option[value=' + json.cm + ']')) {
        node.one('select[name=cm]').set('value', '' + json.cm);
    }
    // Add event handlers (first time only).
    if (!M.availability_ctsubmission.form.addedEvents) {
        M.availability_ctsubmission.form.addedEvents = true;
        var root = Y.one('.availability-field');
        root.delegate('change', function() {
            // Whichever dropdown changed, just update the form.
            M.core_availability.form.update();
        }, '.availability_ctsubmission select');
    }

    return node;
};

M.availability_ctsubmission.form.fillValue = function(value, node) {
    value.cm = parseInt(node.one('select[name=cm]').get('value'), 10);
};

M.availability_ctsubmission.form.fillErrors = function(errors, node) {
    var cmid = parseInt(node.one('select[name=cm]').get('value'), 10);
    if (cmid === 0) {
        errors.push('availability_ctsubmission:error_selectcmid');
    }
};
