<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * DM - Availability Window - Settings file
 *
 * @package     availability_dmavailabilitywindow
 * @copyright   2020 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

global $ADMIN;
if ($ADMIN->fulltree) {

    $name = 'availability_dmavailabilitywindow/numberofrestrictions';
    $title = get_string('numberofrestrictions', 'availability_dmavailabilitywindow');
    $description = get_string('numberofrestrictions_desc', 'availability_dmavailabilitywindow');
    $defaultsetting = "2";
    $setting = new admin_setting_configtext($name, $title, $description, $defaultsetting, PARAM_INT);
    $settings->add($setting);

    $numberofrestrictions = get_config('availability_dmavailabilitywindow', 'numberofrestrictions');

    $tagcollid = core_tag_area::get_collection('core', 'course_modules');
    $tags = $DB->get_records_menu('tag',
        array('isstandard' => 1, 'tagcollid' => $tagcollid), 'rawname', 'id,rawname');

    if (!empty($tags) && $numberofrestrictions){
        for ($i = 1;  $i <= $numberofrestrictions; $i++) {
            $name = 'availability_dmavailabilitywindow/availabilitywindowheader'.$i;
            $title = get_string('restriction', 'availability_dmavailabilitywindow', $i);
            $description = '';
            $setting = new admin_setting_heading($name, $title, $description);
            $settings->add($setting);

            $name = 'availability_dmavailabilitywindow/tag'.$i;
            $title = get_string('tag', 'availability_dmavailabilitywindow', $i);
            $description = '';
            $defaultsetting = '';
            $setting = new admin_setting_configselect($name, $title, $description, $defaultsetting, $tags);
            $settings->add($setting);

            $name = 'availability_dmavailabilitywindow/availabilitywindow'.$i;
            $title = get_string('availabilitywindow', 'availability_dmavailabilitywindow', $i);
            $description = get_string('availabilitywindow_desc', 'availability_dmavailabilitywindow');
            $defaultsetting = "student,0,5\nclassroom-teacher,2,5\nr-sa,2,5";
            $setting = new admin_setting_configtextarea($name, $title, $description, $defaultsetting);
            $settings->add($setting);
        }
    }
}