/**
 * JavaScript for form editing group conditions.
 *
 * @module moodle-availability_missingproctorreports-form
 */
M.availability_missingproctorreports = M.availability_missingproctorreports || {};

/**
 * @class M.availability_missingproctorreports.form
 * @extends M.core_availability.plugin
 */
M.availability_missingproctorreports.form = Y.Object(M.core_availability.plugin);

/**
 * Initialises this plugin.
 *
 * @method initInner
 * @param {Array} name Name
 */
M.availability_missingproctorreports.form.initInner = function(name) {
    this.name = name;
};

M.availability_missingproctorreports.form.getNode = function(json) {
    // Create HTML structure.
    var html = '<label>' + M.util.get_string('title', 'availability_missingproctorreports') +
        ' <input style="display: none" type="checkbox"/></label>';
    var node = Y.Node.create('<span>' + html + '</span>');

    // Set initial values based on the value from the JSON data in Moodle
    // database. This will have values undefined if creating a new one.
    if (json.allow) {
        node.one('input').set('checked', true);
    }

    // Add event handlers (first time only).
    if (!M.availability_missingproctorreports.form.addedEvents) {
        M.availability_missingproctorreports.form.addedEvents = true;
        var root = Y.one('#fitem_id_availabilityconditionsjson');
        root.delegate('change', function() {
            // The key point is this update call. This call will update
            // the JSON data in the hidden field in the form, so that it
            // includes the new value of the checkbox.
            M.core_availability.form.update();
        }, '.availability_missingproctorreports input');
    }

    return node;
};

M.availability_missingproctorreports.form.fillValue = function(value, node) {
    // This function gets passed the node (from above) and a value
    // object. Within that object, it must set up the correct values
    // to use within the JSON data in the form. Should be compatible
    // with the structure used in the __construct and save functions
    // within condition.php.
    var checkbox = node.one('input');
    value.allow = checkbox.get('checked') ? true : false;
};

M.availability_missingproctorreports.form.fillErrors = function(errors, node) {
    // If the user has selected something invalid, this optional
    // function can be included to report an error in the form. The
    // error will show immediately as a 'Please set' tag, and if the
    // user saves the form with an error still in place, they'll see
    // the actual error text.

    // In this example an error is not possible...
    if (false) {
        // ...but this is how you would add one if required. This is
        // passing your component name (availability_missingproctorreports) and the
        // name of a string within your lang file (error_message)
        // which will be shown if they submit the form.
        node.one('input');
        errors.push('availability_missingproctorreports:error_message');
    }
};
