<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * UTILS
 *
 * @package block_ned_student_menu
 * @copyright 2019 Michael Gardener
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 */

namespace block_ned_student_menu;
use block_ned_student_menu\shared_lib as SH;

defined('MOODLE_INTERNAL') || die();

/** @var \stdClass $CFG */
require_once($CFG->dirroot.'/blocks/ned_student_menu/lib.php');

class utils {
    public static function kica_gradebook_enabled($courseid=0) {
        if ($courseid){
            $kica = get_kica_if_exists($courseid);
            return $kica->enabled ?? false;
        } else {
            return is_kica_exists();
        }
    }

    /**
     * @param $cmid
     * @param $studentid
     * @param $type
     * @return array|null
     * @throws \dml_exception
     */
    public static function render_copyleaks_score($cm, $studentid, $type, $checkeligibility = false, $history = false) {
        global $DB;
        $none = ['-', []];

        if ($checkeligibility) {
            if ($cm->modname != 'assign' || !$DB->record_exists('plagiarism_copyleaks_config', ['cm' => $cm->id, 'name' => 'plagiarism_copyleaks_enable', 'value' => 1])) {
                return $none;
            }

            $tags = SH::cm_get_tags($cm);

            if (!$tags || !in_array(SH::TAG_SUMMATIVE, $tags)) {
                return $none;
            }
        }

        if ($cm->modname == 'quiz' || $history) {
            $limitnum = 0;
        } else {
            $limitnum = 1;
        }

        $submittedfiles = $DB->get_records('plagiarism_copyleaks_files', [
            'cm' => $cm->id, 'userid' => $studentid, 'statuscode' => 'success'
        ], 'lastmodified DESC', '*', 0, $limitnum);

        if (empty($submittedfiles)) {
            return $none;
        }
        $plagiarismdetails = [];
        $scores = [];

        foreach ($submittedfiles as $submittedfile) {
            // Plagiarism Score level class.
            $scores[] = $submittedfile->{$type};
            $scorelevelclass = '';
            if ($submittedfile->{$type} <= 40) {
                $scorelevelclass = "cls-plag-score-level-low";
            } else if ($submittedfile->{$type} <= 80) {
                $scorelevelclass = "cls-plag-score-level-mid";
            } else {
                $scorelevelclass = "cls-plag-score-level-high";
            }
            if ($cm->modname == 'quiz') {
                $url = new \moodle_url('/mod/quiz/review.php', [
                    'attempt' => $submittedfile->itemid,
                ]);
            } else if ($cm->modname == 'assign') {
                $url = new \moodle_url('/mod/assign/view.php', [
                    'id' => $cm->id,
                    'course' => $cm->course,
                    'action' => 'grader',
                    'userid' => $studentid
                ]);
            }
            $plagiarismdetails[] = \html_writer::tag(
                'div',
                \html_writer::tag(
                    'div',
                    (isset($submittedfile->{$type}) ?
                        \html_writer::tag('span', '', ['class' => "score-level $scorelevelclass"]) .
                        \html_writer::link($url ?? '#', $submittedfile->{$type}, ['target' => '_blank']) : '-'),
                    array('class' => 'cls-score-container')
                ),
                array('class' => 'cls-result-item')
            );
        }

        return [\html_writer::tag('div',implode(' ', $plagiarismdetails),['class' => 'cls-details-content']), $scores];
    }
}