<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_student_menu
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once($CFG->dirroot.'/mod/assignment/lib.php');

defined('MOODLE_INTERNAL') || die();

define('STUDENTMENU_ACTIVITYSETTING', '1');
define('STUDENTMENU_PASSGRADEPERCENT', '2');

use block_ned_student_menu as NED;
use block_ned_student_menu\shared_lib as SH;

require_once($CFG->dirroot. '/blocks/ned_student_menu/common_lib.php');
require_once($CFG->dirroot. '/lib/grade/grade_item.php');

/**
 * @param $completed
 * @param $incompleted
 * @param $saved
 * @param $notattempted
 * @param $waitingforgrade
 *
 * @return array - $items
 */
function block_ned_student_get_activity_menu($completed, $incompleted, $saved, $notattempted, $waitingforgrade){
    $items = [];

    $link = function($number_activity, $status){
        $text = $number_activity .' '. SH::str($status);
        return SH::icon_get_nge_by_status($status).' '.SH::span($text, '');
    };

    // Completed.
    if (!is_null($completed)) {
        $items[] = $link($completed, SH::STATUS_COMPLETED);
        if ($incompleted) {
            // Incomplete.
            $items[] = $link($incompleted, SH::STATUS_INCOMPLETED);
        }

    }

    // Draft.
    if (!is_null($saved) && $saved) {
        $items[] = $link($saved, SH::STATUS_DRAFT);
    }

    // Not Attempted.
    if (!is_null($notattempted)) {
        $items[] = $link($notattempted, SH::STATUS_NOTATTEMPTED);
    }
    // Waiting for grade.
    if (!is_null($waitingforgrade)) {
        $items[] = $link($waitingforgrade, SH::STATUS_UNMARKED);
    }

    return $items;
}

/**
 * Get block_ned_teacher_tools config for course, based on site block_ned_teacher_tools config and course block settings
 * @param $course_id
 *
 * @return object
 * @throws \dml_exception
 */
function block_ned_student_menu_get_teacher_tools_block_config($course_id){
    $config = NED\get_site_and_course_block_config($course_id, SH::TT_NAME);
    $config->resubmission_assignments = $config->enableresubmissions ?
        \local_ned_controller\tt_config_manager::get_enabled_resubmission_activities($course_id, false) : [];

    return $config;
}
