<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_student_menu
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/blocks/ned_student_menu/lib.php');

$yesnooptions = array(
    '1' => get_string('yes', 'block_ned_student_menu'),
    '0' => get_string('no', 'block_ned_student_menu')
);
$showhideoptions = array(
    '1' => get_string('show', 'block_ned_student_menu'),
    '0' => get_string('hide', 'block_ned_student_menu')
);

// Block Info.
$settings->add( new admin_setting_configempty('block_ned_student_menu/blockinfo',
        get_string('blockinfo', 'block_ned_student_menu'),
        '<a target="_blank" href="http://ned.ca/student-menu">http://ned.ca/student-menu</a>'
    )
);

// General Settings.
$settings->add(
    new admin_setting_heading(
        'generalsettings',
        get_string('generalsettings', 'block_ned_student_menu'),
        ''
    )
);

// My Progress.
$settings->add(
    new admin_setting_heading(
        'myprogress',
        get_string('myprogress', 'block_ned_student_menu'),
        ''
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/showcompleted',
        get_string('completed', 'block_ned_student_menu'),
        '',
        1,
        $showhideoptions
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/shownotattempted',
        get_string('notattempted', 'block_ned_student_menu'),
        '',
        1,
        $showhideoptions
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/showwaitingforgrade',
        get_string('waitingforgrade', 'block_ned_student_menu'),
        '',
        1,
        $showhideoptions
    )
);

$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/showdraft',
        get_string('showdraft', 'block_ned_student_menu'),
        '',
        '1',
       $yesnooptions
    )
);

$passgradeoptions = array(
    STUDENTMENU_ACTIVITYSETTING => get_string('useactivitysetting', 'block_ned_student_menu'),
    STUDENTMENU_PASSGRADEPERCENT => get_string('usepassgradepercent', 'block_ned_student_menu'),
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/passgrade',
        get_string('passgrade', 'block_ned_student_menu'),
        '',
        STUDENTMENU_ACTIVITYSETTING,
        $passgradeoptions
    )
);
$settings->add(
    new admin_setting_configtext(
        'block_ned_student_menu/passgradepercent',
        get_string('passgradepercent', 'block_ned_student_menu'),
        '',
        50,
        PARAM_INT
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/indicateofflineactivity',
        get_string('indicateofflineactivity', 'block_ned_student_menu'),
        '',
        1,
        $yesnooptions
    )
);


// Quick links.
$settings->add(
    new admin_setting_heading(
        'quicklinks',
        get_string('quicklinks', 'block_ned_student_menu'),
        ''
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/showgradebook',
        get_string('showgradebook', 'block_ned_student_menu'),
        '',
        1,
        $showhideoptions
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/showclassparticipants',
        get_string('showclassparticipants', 'block_ned_student_menu'),
        '',
        1,
        $showhideoptions
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/replacewithkicagrade',
        get_string('replacewithkicagrade', 'block_ned_student_menu'),
        '',
        1,
        $yesnooptions
    )
);

// Layout and format.
$settings->add(
    new admin_setting_heading(
        'layoutandformat',
        get_string('layoutandformat', 'block_ned_student_menu'),
        ''
    )
);
$settings->add(
    new admin_setting_configtext(
        'block_ned_student_menu/blocktitlesitelevel',
        get_string('blocktitlesitelevel', 'block_ned_student_menu'),
        '',
        get_string('pluginname', 'block_ned_student_menu'),
        PARAM_TEXT
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/showcourselink',
        get_string('showcourselink', 'block_ned_student_menu'),
        '',
        0,
        $showhideoptions
    )
);
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/showtitles',
        get_string('titlesforlinkclusters', 'block_ned_student_menu'),
        '',
        1,
        $showhideoptions
    )
);

// Custom links.
$settings->add(
    new admin_setting_heading(
        'customlinks',
        get_string('customlinks', 'block_ned_student_menu'),
        ''
    )
);
$settings->add(
    new admin_setting_configtext(
        'block_ned_student_menu/customlinkstitle',
        get_string('customlinkstitle', 'block_ned_student_menu'),
        '',
        get_string('courseresources', 'block_ned_student_menu')
    )
);
$numberoflinksoptions = array();
for ($i = 0; $i <= 10; $i++) {
    $numberoflinksoptions[$i] = $i;
}
$settings->add(
    new admin_setting_configselect(
        'block_ned_student_menu/numberoflinks',
        get_string('numberoflinks', 'block_ned_student_menu'),
        '',
        0,
        $numberoflinksoptions
    )
);
$settings->add(
    new admin_setting_configempty(
        'block_ned_student_menu/iconcoodes',
        get_string('iconcoodes', 'block_ned_student_menu'),
        '<a target="_blank" href="http://fontawesome.io/icons/">http://fontawesome.io/icons/</a>'
    )
);

$numberoflinks = get_config('block_ned_student_menu', 'numberoflinks');

$linkbehaviouroptions = array(
    '_blank' => get_string('newwindow', 'block_ned_student_menu'),
    '_self' => get_string('samewindow', 'block_ned_student_menu'),
    '_popup' => get_string('popup', 'block_ned_student_menu')
);


if (!empty($numberoflinks)) {
    for ($i = 1; $i <= (int)$numberoflinks; $i++) {
        // Link.
        $settings->add(
            new admin_setting_heading(
                'link'.$i,
                get_string('link', 'block_ned_student_menu').' '.$i,
                ''
            )
        );
        $settings->add(
            new admin_setting_configtext(
                'block_ned_student_menu/iconcode_'.$i,
                get_string('iconcode', 'block_ned_student_menu'),
                '',
                'fa-square-o'
            )
        );
        $settings->add(
            new admin_setting_configtext(
                'block_ned_student_menu/customlinkstitle_'.$i,
                get_string('title', 'block_ned_student_menu'),
                '',
                ''
            )
        );
        $settings->add(
            new admin_setting_configtext(
                'block_ned_student_menu/customlinkurl_'.$i,
                get_string('link', 'block_ned_student_menu'),
                '',
                '',
                PARAM_URL
            )
        );
        $settings->add(
            new admin_setting_configselect(
                'block_ned_student_menu/linkbehaviour_'.$i,
                get_string('linkbehaviour', 'block_ned_student_menu'),
                '',
                '_self',
                $linkbehaviouroptions
            )
        );
    }
}
