<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_student_menu
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_student_menu as NED;
use block_ned_student_menu\shared_lib as SH;

if (!isset($CFG)){
    require_once('../../config.php');
}
require_once(__DIR__ . '/common_lib.php');

$courseid = required_param('courseid', PARAM_INT);
$show = optional_param('show', 'all', PARAM_ALPHAEXT);
$fs_type = optional_param('fs_type', NED\USUAL_ACTIVITY, PARAM_INT);

if (!$course = $DB->get_record('course', ['id' => $courseid])) {
    SH::print_error('Course ID was incorrect');
}

if (!$PAGE->has_set_url()) {
    require_login($course);
}
$context = context_course::instance($courseid);
$istudent = has_capability('mod/assignment:submit', $context);

// Only student should see this!
if (!$istudent) {
    SH::print_error('Only students can use this page!');
}

NED\render_student_progress_page($course, $USER, $show, $fs_type);
