define(['jquery', 'core/modal_factory', 'core/templates',], function($, ModalFactory, Templates) {
    return {
        add_modal: function(selector) {
            if (!Array.isArray(selector)){
                selector = [selector];
            }

            $(document).ready(function() {
                for (let i=0; i<selector.length; i++){
                    let elem = $(selector[i]);
                    let title = elem.data('title');
                    let body = elem.data('body');
                    let footer = elem.data('footer');
                    let set_class = elem.data('class');

                    let templ = elem.data('template');

                    if (templ){
                        let data = elem.data('data') || {};
                        Templates.render(templ, data).done(function(html){
                            set_modal(elem, title, html, footer, set_class);
                        });
                    } else {
                        set_modal(elem, title, body, footer, set_class);
                    }

                }

            });

            function set_modal(elem, title='', body='', footer='', set_class=''){
                ModalFactory.create({
                    title: title,
                    body: body,
                    footer: footer,
                }, elem)
                    .then(function(modal) {
                        modal.getModal().addClass(set_class);
                    });
            }
        },
    };
});
