define(['jquery', 'core/log'], function($, log) { return {
init: function() {
    $(document).ready(function(){
        let $form = $('#manage_activities_settings');
        let $ned_checkboxes = $form.find('tbody input.ned_tags_checkbox');
        $form.find('thead input.ned_tags_checkbox').bind('change', function(e){
            $ned_checkboxes.filter(':visible').prop('checked', e.target.checked);
        });

        let $all_rows = $('#ned_moodleform_tags tbody tr:not(.row_none_found)');
        let $row_none_found = $('#ned_moodleform_tags tbody tr.row_none_found');
        let $filter_by_resources = $('.moodleform-tags-filter .filter_by_resources select');
        let $filter_by_activities = $('.moodleform-tags-filter .filter_by_activities select');
        let $filter_by_tags = $('.moodleform-tags-filter .filter_by_tags select');
        let $filter_by_name = $('.moodleform-tags-filter .filter_by_name_text input');
        let $filter_name_start = $('.moodleform-tags-filter .filter_by_name_start input');
        let $filter_name_case = $('.moodleform-tags-filter .filter_by_name_case input');
        let disable_filter_event = false;
        $($filter_by_resources).add($filter_by_activities).add($filter_by_tags).add($filter_by_name).add($filter_name_start).add($filter_name_case)
            .bind('change', filter_event);
        $($filter_by_name).bind('keyup', filter_event);

        $('.moodleform-tags-filter .clear_filters').bind('click', function(e){
            disable_filter_event = true;
            document.activeElement.blur();
            $filter_by_resources.val('none');
            $filter_by_activities.val('all');
            $filter_by_tags.val('all');
            $filter_by_name.val('');
            $filter_name_start[0].checked = false;
            $filter_name_case[0].checked = true;
            disable_filter_event = false;
            filter_event();
            return false;
        });

        filter_event();

        function filter_event(){
            if (disable_filter_event){
                return;
            }
            let filter_sel = '';
            let f_resource = $filter_by_resources.val();
            let f_activity = $filter_by_activities.val();
            let f_tag = $filter_by_tags.val();
            let f_name = $filter_by_name.val();
            let data_name = 'data-name';

            if (f_resource !== 'all'){
                filter_sel += `[data-resource = "${f_resource}"]`;
            }
            if (f_activity !== 'all'){
                filter_sel += `[data-activity = "${f_activity}"]`;
            }
            if (f_tag !== 'all'){
                if (f_tag === 'none'){
                    filter_sel += '[data-tags = ""]';
                } else {
                    filter_sel += `[data-tags *= "(${f_tag})"]`;
                }
            }
            if (f_name.length > 0){
                if ($filter_name_case[0].checked){
                    data_name += '-lower';
                    f_name = f_name.toLowerCase();
                }
                if ($filter_name_start[0].checked){
                    filter_sel += `[${data_name} ^= "${f_name}"]`;
                } else {
                    filter_sel += `[${data_name} *= "${f_name}"]`;
                }
            }

            if (filter_sel.length > 0){
                $all_rows.not(filter_sel).hide();
                let $visible_rows = $all_rows.filter(filter_sel);
                if ($visible_rows.length > 0){
                    $row_none_found.hide();
                    $all_rows.filter(filter_sel).show();
                } else {
                    $row_none_found.show();
                }
            } else {
                $row_none_found.hide();
                $all_rows.show();
            }
        }
    });
}
};});
