define(['jquery', 'core/modal_factory', 'core/modal_events', 'core/notification', 'core/log'],
function ($, ModalFactory, ModalEvents, Notification, log) {
    const original_pathname = window.location.pathname;
    let $iframe = $(`<iframe src="" name="assign_grader_frame" class="assign_grader_frame"></iframe>`);

    return {
        init: function (add_class, texts) {
            let ag_modal = null;
            let $elems = $('#marking-interface .mm-expand');

            // when we get iframe content
            $iframe.on('load', function () {
                let [$cDoc, cWindow] = check_iframe($iframe, ag_modal, texts['externalmodal']);
                if (!cWindow){
                    return;
                }
                // all links open in new tab, even which will be created after this event
                $cDoc.on('click', 'a', function () {
                    $(this).attr('target', '_blank');
                });
                // when iframe try to change location
                $(cWindow).on('unload', function () {
                    if (ag_modal){
                        ag_modal.getModal().addClass('loading');
                    }
                    // location will change after 'unload' event, so we need zero delay
                    setTimeout(function () {
                        check_iframe($iframe, ag_modal, texts['externalmodal']);
                    }, 0);
                });

                if (ag_modal){
                    ag_modal.getModal().removeClass('loading');
                }
            });

            // call modal window
            $elems.on('click', function () {
                let new_url = $(this).data('url');
                if (!ag_modal){
                    ModalFactory.create({
                        title: texts['title'],
                        body: `<div class="text-loading">${texts['loading']}</div>`,
                        footer: '',
                    }).done(function (modal) {
                        ag_modal = modal;
                        modal.getModal().addClass(add_class);
                        refresh_iframe(modal, $iframe, new_url);
                        modal.getRoot().find('.modal-body').append($iframe);
                    }).fail((ex) => debug_ex(ex, 'create modal'));
                } else {
                    refresh_iframe(ag_modal, $iframe, new_url);
                }
            });
        }
    };

    function debug_ex(ex, reason = 'do something') {
        let message = ex.message ? ex.message : ex.error;
        debug(`Failed to ${reason}: \n${message}\n${ex.debuginfo}\n${ex.backtrace}`);
    }

    function debug(text) {
        log.debug('[marking_manager_assign_grader] ' + text);
    }

    function refresh_iframe(modal, $iframe, new_url) {
        if (!new_url.includes(original_pathname)){
            return;
        }
        if ($iframe.attr('src') !== new_url){
            modal.getModal().addClass('loading');
            $iframe.attr('src', new_url);
        }
        modal.show('');
    }

    function check_iframe($iframe, modal, error_text = '') {
        // check for external link
        let [$cDoc, cWindow] = get_iframe_doc_window($iframe);
        if (!cWindow){
            iframe_error($iframe, modal, error_text);
            return [null, null];
        }

        // check for other page
        if (!check_window_location(cWindow)){
            return [null, null];
        }

        return [$cDoc, cWindow];
    }

    function get_iframe_doc_window($iframe) {
        let $cDoc, cWindow;
        try {
            $cDoc = $($iframe[0].contentDocument.body);
            cWindow = $iframe[0].contentWindow;
        } catch (e) {
            [$cDoc, cWindow] = [null, null];
            debug('find external link');
        }
        return [$cDoc, cWindow];
    }

    function iframe_error($iframe, modal, text = '') {
        debug(`call iframe_error`);
        $iframe.attr('src', original_pathname);
        if (modal && modal.isVisible()){
            modal.hide();
            if (text && text.length){
                Notification.addNotification({
                    message: text,
                    type: 'error'
                });
            }
        } else {
            debug(`modal doesn't exist or invisible, ignore iframe_error`);
        }
    }

    function check_window_location(cWindow) {
        if (cWindow.location && cWindow.location.pathname && original_pathname !== cWindow.location.pathname){
            let url = $iframe.attr('src');
            if (!url || !url.length){
                url = window.location.href;
            }
            cWindow.location = url;
            debug(`find link on other page, try redirect to ${url} ...`);
            return false;
        }
        return true;
    }
});
