define(['jquery', 'core/modal_factory', 'core/templates', 'core/str'], function($, ModalFactory, Templates, str) {
    return {
        init: function() {
            let plugin = 'ned_teacher_tools';
            let plugin_name = 'block_' + plugin;
            var elems = $('.review-modal-message-text');
            elems.on('click', function(e) {
                e.preventDefault();
                ModalFactory.create({
                    type: ModalFactory.types.SAVE_CANCEL,
                    title: str.get_string('review_modal:title', plugin_name),
                    body: str.get_string('review_modal:body', plugin_name),
                })
                    .then(function(modal) {
                        modal.setSaveButtonText(str.get_string('review_modal:button', plugin_name));
                        modal.show();
                    });
            });
        }
    };
});