define(['jquery', 'core/log'], function($, log) { return {
init: function() {
    $(document).ready(function(){
        let $form = $('#manage_activities_settings');
        let $ned_checkboxes = $form.find('tbody input.ned_tags_checkbox');
        $form.find('thead input.ned_tags_checkbox').bind('change', function(e){
            $ned_checkboxes.filter(':visible').prop('checked', e.target.checked);
        });

        let $all_rows = $('#page-blocks-ned_teacher_tools-unused_resubmissions_manager .nedtable tbody tr');
        let $filter_by_courses = $('#page-blocks-ned_teacher_tools-unused_resubmissions_manager #select_course');
        let $filter_count = $('#page-blocks-ned_teacher_tools-unused_resubmissions_manager .ur-count-value');
        let $button_rem = $('#page-blocks-ned_teacher_tools-unused_resubmissions_manager #ur-remove-by-course');
        $($filter_by_courses).bind('change', filter_event);
        $button_rem.bind('click', function(){
            if (confirm($button_rem.data('onclick').replace('\\n', '\n'))){
                let f_course = $filter_by_courses.val();
                if (f_course !== 'all'){
                    $button_rem.attr('href', $button_rem.attr('href') + '&courseid=' + f_course);
                }
                return true;
            }
            return false;
        });

        filter_event();

        function filter_event(){
            let filter_sel = '';
            let f_course = $filter_by_courses.val();

            if (f_course !== 'all'){
                filter_sel += `[data-course = "${f_course}"]`;
            }

            let visible_rows;
            if (filter_sel.length > 0){
                $all_rows.not(filter_sel).hide();
                visible_rows = $all_rows.filter(filter_sel);
            } else {
                visible_rows = $all_rows;
            }
            visible_rows.show();
            $filter_count.text(visible_rows.length);
        }
    });
}
};});
