<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

use local_ned_controller\tt_config_manager as CM;

/**
 * @package    block_ned_teacher_tools
 * @copyright  2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * structure step in charge of constructing the block.xml file for one
 * given block (instance and positions). If the block has custom DB structure
 * that will go to a separate file (different step defined in block class)
 */
class backup_ned_teacher_tools_block_instance_structure_step extends backup_structure_step {

    /**
     * @return backup_nested_element
     * @throws base_element_struct_exception
     * @throws base_step_exception
     * @throws dml_exception
     */
    protected function define_structure() {
        global $DB;

        // Define each element separated
        $block = new backup_nested_element('block', array('id', 'contextid', 'version'), array(
            'blockname', 'parentcontextid', 'showinsubcontexts', 'pagetypepattern',
            'subpagepattern', 'defaultregion', 'defaultweight', 'configdata',
            'timecreated', 'timemodified'));

        $positions = new backup_nested_element('block_positions');

        $position = new backup_nested_element('block_position', array('id'), array(
            'contextid', 'pagetype', 'subpage', 'visible',
            'region', 'weight'));

        // Build the tree
        $block->add_child($positions);
        $positions->add_child($position);

        // Transform configdata information if needed (process links and friends)
        $blockrec = $DB->get_record('block_instances', array('id' => $this->task->get_blockid()));
        if ($attrstotransform = $this->task->get_configdata_encoded_attributes()) {
            $configdata = (array)unserialize(base64_decode($blockrec->configdata));
            foreach ($attrstotransform as $attribute) {
                if (empty($configdata[$attribute])) continue;
                $configdata[$attribute] = $this->contenttransformer->process($configdata[$attribute]);
            }
            // CISSQ -begin-
            $courseid = $this->get_courseid();

            $cfg_fields = CM::BASE_CONFIG_FIELDS;
            $course_config = CM::get_config_course_data($courseid);

            // Check active config fields and save it
            foreach ($course_config as $cmid => $config){
                foreach ($cfg_fields as $field){
                    if($config->$field){
                        $configdata[$field][] = $cmid;
                    }
                }
            }

            // CISSQ -end-
            // save config data to the block config
            $blockrec->configdata = base64_encode(serialize((object)$configdata));
        }
        $blockrec->contextid = $this->task->get_contextid();
        // Get the version of the block
        $blockrec->version = get_config('block_'.$this->task->get_blockname(), 'version');

        // Define sources
        $block->set_source_array(array($blockrec));
        $position->set_source_table('block_positions', array('blockinstanceid' => backup::VAR_PARENTID));

        // File anotations (for fileareas specified on each block)
        foreach ($this->task->get_fileareas() as $filearea) {
            $block->annotate_files('block_' . $this->task->get_blockname(), $filearea, null);
        }

        // Return the root element (block)
        return $block;
    }
}
