<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Block setting redirection
 *
 * @package  block_ned_teacher_tools
 * @author   Michael Gardener <mgardener@cissq.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools\shared_lib as SH;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');

$courseid = required_param('id', PARAM_INT); // Course id.
$blockid = required_param('bui_editid', PARAM_INT);

if (!is_siteadmin()) {
    SH::print_error('nopermissions', 'error', '', '');
}

$url = new moodle_url('/course/view.php',
    ['id' => $courseid, 'bui_editid' => $blockid, 'sesskey' => sesskey()]);

$USER->editing = 1;

redirect($url);