<?php


namespace block_ned_teacher_tools\form;

defined('MOODLE_INTERNAL') || die();

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\course_users_status as TT_status;

class complete_course extends \moodleform{

    protected function definition(){
        global $COURSE, $USER;
        $mform = $this->_form;
        $customdata = $this->_customdata;

        $select = [
            0 => NED\str('choosethestatus'),
            TT_status::STATUS_IN_PROGRESS => NED\str('courseinprogress'),
            TT_status::STATUS_WAITING_FOR_FINAL_GRADE => NED\str('coursecompletewffg'),
        ];
        $cus = new TT_status($COURSE->id);
        if($cus->meets_course_criteria($USER->id) || is_siteadmin()){
            $select[TT_status::STATUS_PASS] = NED\str('coursecompletepass');
        }
        $select[TT_status::STATUS_FAIL] = NED\str('coursecompletefail');
        $select[TT_status::STATUS_WAITING_FOR_INTERNAL_REVIEW] = NED\str('coursecompletewffir');

        $mform->addElement('select', 'complete_course_select',
            NED\str('selectcompletionstatus'), $select);
        $mform->addElement('hidden', 'complete_course_data', '' );
        $mform->setType('complete_course_data', PARAM_RAW);


        foreach($customdata as $kcd => $cdd){
            $mform->addElement('hidden', $kcd, $cdd );
            $mform->setType($kcd, PARAM_RAW);
        }
    }
}
