<?php
/**
 * This is form to display the modules deadlines
 *
 * @package    block_ned_teacher_tools
 * @category   form
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\form;

defined('MOODLE_INTERNAL') || die;
/** @var \stdClass $CFG */
require_once($CFG->libdir.'/formslib.php');

use block_ned_teacher_tools\shared_lib as SH;
use block_ned_teacher_tools\deadline_manager as DM;

/**
 * This is form to display the modules deadlines
 *
 * @package    block_ned_teacher_tools
 */
class deadline_manager_edit_form extends \moodleform {
    /**
     * @var string
     */
    public $pagetype;
    /**
     * @var \block_ned_teacher_tools\deadline_manager_entity
     */
    public $dm_entity;

    /**
     * The constructor function calls the abstract function definition() and it will then
     * process and clean and attempt to validate incoming data.
     *
     * @param mixed $action the action attribute for the form. If empty defaults to auto detect the
     *              current url. If a moodle_url object then outputs params as hidden variables.
     * @param mixed $customdata if your form defintion method needs access to data such as $course
     *              $cm, etc. to construct the form definition then pass it in this array. You can
     *              use globals for somethings.
     * @param string $method if you set this to anything other than 'post' then _GET and _POST will
     *               be merged and used as incoming data to the form.
     * @param string $target target frame for form submission. You will rarely use this. Don't use
     *               it if you don't need to as the target attribute is deprecated in xhtml strict.
     * @param mixed $attributes you can pass a string of html attributes here or an array.
     *               Special attribute 'data-random-ids' will randomise generated elements ids. This
     *               is necessary when there are several forms on the same page.
     *               Special attribute 'data-double-submit-protection' set to 'off' will turn off
     *               double-submit protection JavaScript - this may be necessary if your form sends
     *               downloadable files in response to a submit button, and can't call
     *               \core_form\util::form_download_complete();
     * @param bool $editable
     * @param array $ajaxformdata Forms submitted via ajax, must pass their data here, instead of relying on _GET and _POST.
     */
    public function __construct($action=null, $customdata=null, $method='post', $target='', $attributes=null, $editable=true, $ajaxformdata=null){
        $this->dm_entity = $customdata['dm_entity'];
        $this->pagetype = $customdata['pagetype'] ?? DM::PAGE_USER_EDIT;
        parent::__construct($action, $customdata, $method, $target, $attributes, $editable, $ajaxformdata);
    }

    /**
     * Return current DM source based on the page type
     *
     * @return string
     */
    public function get_current_source(){
        return $this->pagetype == DM::PAGE_USER_EDIT ? DM::SOURCE_USER : DM::SOURCE_GROUP;
    }

    /**
     * @see lib/moodleform#definition()
     */
    public function definition() {
        $mform = $this->_form;
        $mform->_attributes['class'] = $mform->_attributes['class'] ?? '';
        $mform->_attributes['class'].= ' deadline-manager-report';

        $user_pagetype = $this->pagetype == DM::PAGE_USER_EDIT;
        $current_source = $this->get_current_source();
        $formatted_source = DM::format_source($current_source);

        $buttonarray = array();
        $buttonarray[] =& $mform->createElement('hidden', 'p', $this->pagetype);
        $mform->setType('p', PARAM_TEXT);
        $buttonarray[] =& $mform->createElement('submit', 'cancel', get_string('cancel'), ['class' => 'cancel']);
        $buttonarray[] =& $mform->createElement('submit', 'submitbutton', get_string('savechanges'), ['class' => 'savechanges']);
        $mform->addGroup($buttonarray, 'dmbuttonar', '', array(' '), false);

        $mform->addElement('html',
            SH::tag_start('table', 'nedtable fullwidth form-table').
            SH::tag_start('thead').
            SH::tag_start('tr').
            SH::tag('th', SH::str('activity'), '', ['scope' => "col"]).
            SH::tag('th', SH::str('source'), '', ['scope' => "col"]).
            SH::tag('th', SH::str('deadline'), '', ['scope' => "col"])
        );

        if ($user_pagetype) {
            $mform->addElement('html', SH::tag('th', SH::str('extensions'), '', ['scope' => "col"]));
        }
        $mform->addElement('html',
            SH::tag_end('tr').
            SH::tag_end('thead').
            SH::tag_start('tbody')
        );

        foreach ($this->dm_entity->iterate() as $cmid => $dma){
            if (!$dma->is_enabled()) continue;

            $row_class = [];
            if ($dma->is_midterm()){
                $row_class[] = 'activity-midterm';
            }
            $activity = SH::q_cm_student_link($dma->cm, $dma->userid, $dma->courseid);
            $mform->addElement('html',
                SH::tag_start('tr', $row_class).
                SH::tag('td', $activity, '', ['nowrap' => "nowrap"]).
                SH::tag('td', $formatted_source)
            );

            $mform->addElement('html', SH::tag_start('td'));
            $dma->form_add_element($mform, $current_source);
            $mform->addElement('html', SH::tag_end('td'));

            if ($user_pagetype){
                $show_extension = '';
                [$use_extension, $numberofextensions] = $dma->get_activity_extension_data();
                if ($use_extension && $numberofextensions > 0){
                    $show_extension = SH::div($numberofextensions, 'extensions numberofextensions text-center');
                }
                $mform->addElement('html', SH::tag('td', $show_extension));
            }

            $mform->addElement('html', SH::tag_end('tr'));
        }
        $mform->addElement('html',
            SH::tag_end('tbody').
            SH::tag_end('table')
        );

        $this->add_action_buttons();
    }

    /**
     * Some extra validation.
     * If there are errors return array of errors ("fieldname"=>"error message")
     *
     * @param array $data array of ("fieldname"=>value) of submitted data
     * @param array $files array of uploaded files "element_name"=>tmp_file_path
     * @return array of "element_name"=>"error_description" if there are errors,
     *         or an empty array if everything is OK (true allowed for backwards compatibility too).
     */
    public function validation($data, $files){
        $source = $this->get_current_source();
        $this->dm_entity->form_load_data($data, $source);
        return $this->dm_entity->form_get_validation($source, true);
    }
}
