<?php

namespace block_ned_teacher_tools\form;

use local_ned_controller\tt_config_manager as CM;
use block_ned_teacher_tools\shared_lib as SH;

defined('MOODLE_INTERNAL') || die();
/** @var \stdClass $CFG */
require_once($CFG->libdir.'/formslib.php');

/**
 * Class manage_activities_settings
 */
class manage_activities_settings extends \moodleform {
    const TAG_TAGS = 'tags';
    const CHECKBOX_TAG = 'checkbox_tag';

    protected $_course;
    protected $_activities;
    protected $_tags = [];
    protected $_url;

    /**
     * block_ned_teacher_tools_moodleform_tag constructor.
     *
     * @param object             $course
     * @param \moodle_url|string $url
     */
    public function __construct($course, $url){
        $this->_course = $course;
        $this->_activities = SH::get_course_cms($course);
        $this->_url = $url;

        parent::__construct('modedit.php');
    }

    /**
     * Form definition
     */
    public function definition(){
        global $USER;
        $mform =& $this->_form;
        $mform->_attributes['id'] = 'manage_activities_settings';
        $mform->_attributes['action'] = $this->_url;
        $courseid = $this->_course->id;

        $table = SH::html_table('nedtable', 'ned_moodleform_tags');

        $head_checkbox = $mform->createElement('advcheckbox', 'head_checkbox', '');
        $head_checkbox->_attributes['class'] = 'ned_tags_checkbox';
        $tag_options = ['itemtype' => 'course_modules', 'component' => 'core'];
        $base_list = ['all' => get_string('all'), 'none' => get_string('none')];

        $all_tags = $activities = $resources = [];
        $all_activities = $all_resources = [];
        $contentitemservice = \core_course\local\factory\content_item_service_factory::get_content_item_service();
        $modules = $contentitemservice->get_content_items_for_user_in_course($USER, $this->_course);
        foreach ($modules as $name => $module){
            if ($module->archetype === MOD_ARCHETYPE_SYSTEM) continue;

            if ($module->archetype == MOD_ARCHETYPE_RESOURCE){
                $all_resources[$module->name] = $module->title;
            } else {
                $all_activities[$module->name] = $module->title;
            }
        }

        $class_name = 'cell-name';
        $class_resubmissions = 'cell-resubmissions';
        $class_deadlinemanager = 'cell-deadlinemanager';
        $class_dm_extensions = 'cell-dmextensions';
        $class_tags = 'cell-tags';

        $table->head = [
            SH::cell($head_checkbox->toHtml().SH::str('activityname'), $class_name),
            SH::cell(SH::str('resubmissions'), $class_resubmissions),
            SH::cell(SH::str('deadlinemanager'), $class_deadlinemanager),
            SH::cell(SH::str('extension'), $class_dm_extensions),
            SH::cell(get_string('tags', 'tag'), $class_tags),
        ];

        $create_checkbox_cell = function($mod, $field, $value, $classes) use ($mform){
            $field_name = $this->get_name($mod, $field);
            $checkbox = $mform->createElement('advcheckbox', $field_name, '');
            $checkbox->setValue($value);
            return SH::cell($checkbox->toHtml(), $classes);
        };

        foreach ($this->_activities as $mod){
            if ($mod->modname === 'label'){
                continue;
            }
            $cmid = $mod->id;

            //render cm name and icon
            $row = SH::row([]);
            $name = $this->get_name($mod);
            $label = SH::mod_link($mod, 20, false, 'name');

            //render tag checkbox
            $checkbox = $mform->createElement('advcheckbox', $this->get_name($mod, static::CHECKBOX_TAG), '');
            $checkbox->_attributes['class'] = 'ned_tags_checkbox';
            $label = $checkbox->toHtml().$label;
            $row->cells[] = SH::cell($label, $class_name);

            //render resubmission checkbox
            if (CM::rm_is_cm_enabled_by_type($mod)){
                $field = CM::CONFIG_RM_FIELD;
                $checkbox_value = CM::is_resubmission_enable_for_activity($cmid, $courseid);
                $row->cells[] = $create_checkbox_cell($mod, $field, $checkbox_value, $class_resubmissions);
            } else {
                $row->cells[] = '';
            }


            if (CM::dm_is_cm_enabled_by_type($mod, $courseid)){
                //render DM checkbox
                $field = CM::CONFIG_DM_FIELD;
                $checkbox_value = CM::is_dm_enable_for_activity($cmid, $courseid);
                $row->cells[] = $create_checkbox_cell($mod, $field, $checkbox_value, $class_deadlinemanager);

                //render extension checkbox
                $field = CM::CONFIG_EXT_FIELD;
                $checkbox_value = CM::is_extension_enable_for_activity($cmid, $courseid);
                $row->cells[] = $create_checkbox_cell($mod, $field, $checkbox_value, $class_dm_extensions);
                $mform->disabledIf($this->get_name($mod, $field), $this->get_name($mod, CM::CONFIG_DM_FIELD));
            } else {
                $row->cells[] = '';
                $row->cells[] = '';
            }

            /** @var \MoodleQuickForm_tags $tags_selector */
            $tags_selector = $mform->createElement('tags', $name, $label, $tag_options);
            $tags_selector->_attributes['ned_tags_selector'] = '';
            $tags = \core_tag_tag::get_item_tags_array('core', 'course_modules', $cmid);
            $tags_selector->setValue($tags);
            $this->_tags[$cmid] = $tags;
            $row->cells[] = SH::cell($tags_selector->toHtml(), $class_tags);

            // get all tags (id => fullname) for filter
            foreach ($tags as $tag_key => $tag_name){
                if (isset($all_tags[$tag_key])){
                    continue;
                }
                $all_tags[$tag_key] = $tag_name;
            }
            // this data is used by js-filter
            if (isset($all_resources[$mod->modname])){
                $resources[$mod->modname] = $all_resources[$mod->modname];
                $row->attributes['data-resource'] = $mod->modname;
                $row->attributes['data-activity'] = 'none';
            } elseif (isset($all_activities[$mod->modname])){
                $activities[$mod->modname] = $all_activities[$mod->modname];
                $row->attributes['data-resource'] = 'none';
                $row->attributes['data-activity'] = $mod->modname;
            } else {
                debugging("Unknowing modname {$mod->modname}", DEBUG_DEVELOPER);
                // It shows for "All" selector only
                $row->attributes['data-resource'] = 'unknowing';
                $row->attributes['data-activity'] = 'unknowing';
            }
            $row->attributes['data-name'] = $mod->name;
            $row->attributes['data-name-lower'] = strtolower($mod->name);
            $row->attributes['data-tags'] = !empty($tags) ? ('('.implode('),(', array_keys($tags)).')') : '';

            $table->data[] = $row;
        }

        // add row for none results by filtering
        $col_nums = count($table->head);
        $last_row = array_fill(0, $col_nums, '');
        $last_row[(int)floor($col_nums / 2)] = SH::cell(SH::div(SH::str('filter_none_found'), ''));
        $table->data[] = SH::row($last_row, 'row_none_found', ['style' => 'display: none;']);

        // Create filter
        $filter_elems = $filter_elems_name = [];

        $name = 'filter_by_name_text';
        $elem = \html_writer::empty_tag('input', ['type' => 'text', 'name' => $name, 'id' => $name]);
        $filter_elems_name[$name] = $elem;

        $name = 'filter_by_name_start';
        $elem = \html_writer::checkbox($name, 0, false, '', ['id' => $name]);
        $filter_elems_name[$name] = $elem;

        $name = 'filter_by_name_case';
        $elem = \html_writer::checkbox($name, 1, true, '', ['id' => $name]);
        $filter_elems_name[$name] = $elem;
        $filter_elems['filter_by_name'] = $filter_elems_name;

        $name = 'filter_by_resources';
        ksort($resources);
        $elem = \html_writer::select(array_merge($base_list, $resources), $name, 'none', [], ['id' => $name]);
        $filter_elems[$name] = $elem;

        $name = 'filter_by_activities';
        ksort($activities);
        $elem = \html_writer::select(array_merge($base_list, $activities), $name, 'all', [], ['id' => $name]);
        $filter_elems[$name] = $elem;

        $name = 'filter_by_tags';
        $elem = \html_writer::select($base_list + $all_tags, $name, 'all', [], ['id' => $name]);
        $filter_elems[$name] = $elem;

        $print_elems = function($elems) use (&$print_elems){
            $result = '';
            foreach ($elems as $name => $elem){
                if (is_array($elem)){
                    $result .= SH::div($print_elems($elem), $name);
                    continue;
                }
                $label = \html_writer::label(SH::str($name), $name);
                $result .= SH::div($label.$elem, $name.' filter-element');
            }
            return $result;
        };

        $filter_div = $print_elems($filter_elems);
        $filter_div .= SH::link('#', SH::str('filter_clear_filter'), 'clear_filters btn btn-secondary');
        $mform->addElement('html', SH::div($filter_div, 'moodleform-tags-filter'));

        // Draw table and its basement
        $mform->addElement('html', SH::div(SH::render_table($table), 'table-moodleform-tags'));

        $mform->addElement('html', SH::div_start('bulk_edit'));
        $tags_selector = $mform->createElement('tags', 'bulk_add', SH::str('bulk_add'), $tag_options);
        $tags_selector->_attributes['ned_tags_selector'] = '';
        $mform->addElement($tags_selector);
        $tags_selector = $mform->createElement('tags', 'bulk_remove', SH::str('bulk_remove'), $tag_options);
        $tags_selector->_attributes['ned_tags_selector'] = '';
        $mform->addElement($tags_selector);
        $mform->addElement('html', SH::div_end()); // bulk_edit

        $this->add_action_buttons();
    }

    /**
     * Add to form data additional data from elements, which were added through raw html
     * @return object
     */
    public function get_data(){
        global $_POST;
        $data = parent::get_data();
        if (empty($data)){
            return $data;
        }

        $tags_field = static::TAG_TAGS;
        $check_tags_function = fn($val) => is_array($val) ? $val : [];

        $res = !empty($_POST[$tags_field]) ? array_map($check_tags_function, $_POST[$tags_field]) : [];
        $data->{$tags_field} = $res;

        /** Don't use {@see tt_config_manager::BASE_CONFIG_FIELDS} here because there are not all fields setting up in the form */
        $checkboxes = [self::CHECKBOX_TAG, CM::CONFIG_RM_FIELD, CM::CONFIG_DM_FIELD, CM::CONFIG_EXT_FIELD];

        foreach ($checkboxes as $checkbox_name){
            $res = !empty($_POST[$checkbox_name]) ? $_POST[$checkbox_name] : [];
            $data->{$checkbox_name} = $res;
        }

        return $data;
    }

    // New functions

    /**
     * Render & return form as html
     * @return string
     */
    public function draw(){
        SH::js_call_amd('manage_tags');
        //finalize the form definition if not yet done
        if (!$this->_definition_finalized){
            $this->_definition_finalized = true;
            $this->definition_after_data();
        }

        return $this->_form->toHtml();
    }

    /**
     * @return bool
     */
    public function save_data(){
        if ($this->is_cancelled() and !$this->is_submitted()){
            return false;
        }
        $data = $this->get_data();
        if (!$data || !isset($data->submitbutton)){
            return false;
        }

        $courseid = $this->_course->id;
        $create_activities_config = [];
        $ctx = SH::ctx($courseid);

        $tags = static::TAG_TAGS;
        $chb_tag = static::CHECKBOX_TAG; //tag checkbox

        $bulk_add = $data->bulk_add;
        $bulk_remove = $data->bulk_remove;

        $rm_field = CM::CONFIG_RM_FIELD;
        $dm_field = CM::CONFIG_DM_FIELD;
        $ext_field = CM::CONFIG_EXT_FIELD;

        foreach ($this->_activities as $mod){
            $cmid = $mod->id;
            if (!isset($this->_tags[$cmid]) || !isset($data->$tags[$cmid]) || !isset($data->$chb_tag[$cmid])){
                continue;
            }
            $has_updated = false;
            $activity_cfg = [];

            $old_tags = array_values($this->_tags[$cmid]);
            $new_tags = $data->$tags[$cmid];
            if ($data->$chb_tag[$cmid]){
                foreach ($bulk_add as $tag_add){
                    if (!in_array($tag_add, $new_tags)){
                        $new_tags[] = $tag_add;
                    }
                }
                foreach ($bulk_remove as $tag_rem){
                    $key = array_search($tag_rem, $new_tags);
                    if ($key !== false){
                        unset($new_tags[$key]);
                    }
                }
            }

            if ($new_tags != $old_tags){
                \core_tag_tag::set_item_tags('core', 'course_modules', $cmid, $ctx, $new_tags);
            }

            if (CM::rm_is_cm_enabled_by_type($mod)){
                $new_value = !empty($data->$rm_field[$cmid]);
                $old_value = CM::is_resubmission_enable_for_activity($cmid, $courseid);

                if ($old_value != $new_value){
                    $activity_cfg[$rm_field] = $new_value;
                    $has_updated = true;
                }
            }

            if (CM::dm_is_cm_enabled_by_type($mod, $courseid)){
                $new_dm_field = !empty($data->$dm_field[$cmid]);
                if (CM::is_dm_enable_for_activity($cmid, $courseid) != $new_dm_field){
                    $activity_cfg[$dm_field] = $new_dm_field;
                    $has_updated = true;
                }

                $new_ext_field = !empty($data->$ext_field[$cmid]);
                if (CM::is_extension_enable_for_activity($cmid, $courseid) != $new_ext_field){
                    $activity_cfg[$ext_field] = $new_ext_field;
                    $has_updated = true;
                }
            }

            if (!$has_updated || empty($activity_cfg)) continue;

            //need to update values
            $create_activities_config[$cmid] = $activity_cfg;
        }

        CM::save_config_data_in_course($create_activities_config, $courseid);
        return true;
    }

    /**
     * @param        $mod
     * @param string $type
     *
     * @return string
     */
    private function get_name($mod, $type=self::TAG_TAGS){
        $name = $type.'['.$mod->id.']';
        return $name;
    }
}
