<?php
/**
 * @package    block_ned_teacher_tools
 * @subpackage form
 * @category   NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\form;
use block_ned_teacher_tools\shared_lib as SH;

defined('MOODLE_INTERNAL') || die();

/** @var \stdClass $CFG */
require_once($CFG->libdir.'/formslib.php');

/**
 * Form.
 *
 * @package    block_ned_teacher_tools
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class student_extension extends \moodleform {

    /**
     * @throws \coding_exception
     */
    public function definition() {
        $mform = $this->_form;
        $data  = $this->_customdata;
        $groupid = $data['groupid'];
        $studentid = $data['studentid'];
        $courseid = $data['courseid'];

        if (empty($studentid) || empty($courseid)) throw new \Exception('Missing parameters');

        $group = SH::get_group($groupid);
        if (empty($group)){
            $groups = SH::get_all_user_course_groups($courseid, $studentid);
            $group = reset($groups);
        }

        $userextension = SH::db()->get_record('block_ned_teacher_tools_usrd', array('userid' => $studentid, 'courseid' => $courseid));
        $enddate = $userextension ? $userextension->enddate : ($group->enddate ?? '');
        if ($enddate){
            $mform->addElement('static', 'description', SH::str('currentenddate'),
                (!empty($enddate) ? date('d M Y', $enddate) : '')
            );
        }

        $mform->addElement('hidden', 'studentid', $studentid);
        $mform->setType('hidden', PARAM_INT);

        $mform->addElement('hidden', 'groupid', $groupid);
        $mform->setType('groupid', PARAM_INT);

        $mform->addElement('date_selector', 'enddate', SH::str('newenddate'), ['optional' => false]);
        $mform->addRule('enddate', '', 'required', get_string('required'), 'client');

        $mform->addElement('textarea', 'reason', '',
            ['wrap' => 'virtual',  'rows' => "5", 'cols' => "50",
                'placeholder' => SH::str('reasonforextension') . '...']);
        $mform->addRule('reason', '', 'required', get_string('required'), 'client');
    }
}
