<?php

/**
 * @package      block_ned_teacher_tools
 * @subpackage   NED
 * @copyright    2020 NED {@link http://ned.ca}
 * @author       NED {@link http://ned.ca}
 * @license      http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 * @noinspection PhpUnused
 * @noinspection PhpUnusedParameterInspection
 */

defined('MOODLE_INTERNAL') || die();

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;
use block_ned_teacher_tools\course_users_status;
use block_ned_teacher_tools\grading_tracker as GT;
use block_ned_teacher_tools\deadline_manager as DM;
use local_ned_controller\tt_config_manager as CM;

require_once(__DIR__.'/../lib.php');

/**
 * Event observers.
 */
class block_ned_teacher_tools_observer
{
    /**
     * @param \mod_assign\event\submission_graded $event
     */
    public static function mod_assign_submission_graded(\mod_assign\event\submission_graded $event){
        $courseid = $event->courseid;

        $data = $event->get_data();

        $userid = $data["relateduserid"];
        $courses_with_exam = NED\get_courses_with_exam_mod_id($courseid);

        foreach ($courses_with_exam as $course){

            $config = NED\get_block_config($course->id, NED\PLUGIN);

            if (empty($config->autosetwfirstatus)){
                continue;
            }

            $cus = new course_users_status($course->id);
            $cus_statuses = $cus->get_users_statuses($userid, true);
            $modexams = explode(',', $course->exammodid);

            if (isset($cus_statuses[$userid])){
                if ($cus_statuses[$userid]->status != course_users_status::STATUS_WAITING_FOR_FINAL_GRADE){
                    continue;
                }
            }

            $completedexams = 0;
            foreach ($modexams as $modexam){
                [$c, $cm] = get_course_and_cm_from_cmid($modexam);
                $assign = new \assign($cm->context, $cm, $c);

                $grading_status = $assign->get_grading_status($userid);
                if ($grading_status == ASSIGN_GRADING_STATUS_GRADED){
                    $completedexams++;
                }
            }

            if (count($modexams) == $completedexams){
                $cus->add_user_status($userid, course_users_status::STATUS_WAITING_FOR_INTERNAL_REVIEW);
            }
        }
    }

    public static function mod_assign_submission_created(\mod_assign\event\submission_created $event){
        // you can catch draft state here
        // can be called twice for one assignment at once
        return;
    }

    public static function mod_assign_assessable_submitted(\mod_assign\event\assessable_submitted $event){
        //GT::add_activity_by_event($event, GT::MOD_ASSIGN);
    }

    public static function ned_assign_submission_removed(\local_ned_controller\event\submission_removed $event){
        //GT::remove_activity_by_event($event);
    }

    public static function ned_assign_submission_remove_grades(\local_ned_controller\event\submission_remove_grades $event){
        //GT::remove_grade_by_event($event);
    }

    public static function mod_forum_post_created(\mod_forum\event\post_created $event){
        //GT::add_activity_by_event($event, GT::MOD_FORUM);
    }

    public static function mod_forum_discussion_created(\mod_forum\event\discussion_created $event){
        //GT::add_activity_by_event($event, GT::MOD_FORUM);
    }

    public static function mod_quiz_attempt_submitted(\mod_quiz\event\attempt_submitted $event){
        //GT::add_activity_by_event($event, GT::MOD_QUIZ);
    }

    public static function user_graded(\core\event\user_graded $event){
        // can be called many times for one grading at once
        $graderid = $event->userid;
        if ($graderid > 0){
            GT::grade_activity_by_event($event);
        }
    }

    public static function mod_quiz_question_manually_graded(\mod_quiz\event\question_manually_graded $event){
        GT::question_manually_graded($event);
    }

    public static function ned_assign_submission_graded(\local_ned_controller\event\submission_graded $event){
        GT::grade_activity_by_ned_assign_event($event);
    }

    public static function mod_forum_post_deleted(\mod_forum\event\post_deleted $event){
        //GT::check_forum_submission_to_delete_by_event($event);
    }

    public static function mod_forum_discussion_deleted(\mod_forum\event\discussion_deleted $event){
        //GT::check_forum_submission_to_delete_by_event($event);
    }

    public static function core_user_updated(core\event\user_updated $event){
        //GT::user_updated_event($event);
    }

    public static function core_user_deleted(core\event\user_deleted $event){
        /** @see \block_ned_teacher_tools_pre_user_delete() for pre deleted event */
        //GT::user_deleted_event($event);
    }

    public static function core_user_enrolment_updated(core\event\user_enrolment_updated $event){
        //GT::user_enrolment_updated_event($event);
    }

    public static function core_user_enrolment_created(core\event\user_enrolment_created $event){
        //GT::user_enrolment_created_event($event);
    }

    public static function core_user_enrolment_deleted(core\event\user_enrolment_deleted $event){
        //GT::user_enrolment_deleted_event($event);
    }

    public static function core_group_member_added(core\event\group_member_added $event){
        //GT::group_member_added_event($event);
    }

    public static function core_group_member_removed(core\event\group_member_removed $event){
        //GT::group_member_removed_event($event);
    }

    public static function core_role_assigned(core\event\role_assigned $event){
        //GT::role_assigned_event($event);
    }

    public static function core_role_unassigned(core\event\role_unassigned $event){
        //GT::role_unassigned_event($event);
    }

    public static function core_course_deleted(core\event\course_deleted $event){
        //GT::course_deleted_event($event);
    }

    public static function core_course_module_created(core\event\course_module_created $event){
        DM::course_module_created_event($event);
    }

    public static function core_course_module_updated(core\event\course_module_updated $event){
        DM::course_module_updated_event($event);
        //GT::course_module_updated_event($event);
    }

    public static function core_course_module_deleted(core\event\course_module_deleted $event){
        /** @see \block_ned_teacher_tools_pre_course_module_delete() for pre deleted event */
        $data = [
            SH::PAR_CM => $event->contextinstanceid,
        ];
        DM::create_delete_extension_task($data);
        //GT::course_module_deleted_event($event);
    }

    public static function core_group_deleted(core\event\group_deleted $event){
        //GT::group_deleted_event($event);
    }

    public static function mod_assign_group_override_created(mod_assign\event\group_override_created $event){
        //GT::group_override_updated_event($event);
    }

    public static function mod_assign_group_override_updated(mod_assign\event\group_override_updated $event){
        //GT::group_override_updated_event($event);
    }

    public static function mod_assign_group_override_deleted(mod_assign\event\group_override_deleted $event){
        //GT::group_override_updated_event($event);
    }

    public static function mod_quiz_group_override_created(mod_quiz\event\group_override_created $event){
        //GT::group_override_updated_event($event);
    }

    public static function mod_quiz_group_override_updated(mod_quiz\event\group_override_updated $event){
        //GT::group_override_updated_event($event);
    }

    public static function mod_quiz_group_override_deleted(mod_quiz\event\group_override_deleted $event){
        //GT::group_override_updated_event($event);
    }

    public static function mod_assign_user_override_created(mod_assign\event\user_override_created $event){
        //GT::user_override_updated_event($event);
    }

    public static function mod_assign_user_override_updated(mod_assign\event\user_override_updated $event){
        //GT::user_override_updated_event($event);
    }

    public static function mod_assign_user_override_deleted(mod_assign\event\user_override_deleted $event){
        //GT::user_override_updated_event($event);
    }

    public static function mod_quiz_user_override_created(mod_quiz\event\user_override_created $event){
        //GT::user_override_updated_event($event);
    }

    public static function mod_quiz_user_override_updated(mod_quiz\event\user_override_updated $event){
        //GT::user_override_updated_event($event);
    }

    public static function mod_quiz_user_override_deleted(mod_quiz\event\user_override_deleted $event){
        //GT::user_override_updated_event($event);
    }

    public static function core_course_content_deleted(core\event\course_content_deleted $event){
        /** @see \block_ned_teacher_tools_pre_course_delete() for pre deleted event */
        $data = [SH::PAR_COURSE => $event->objectid];
        DM::create_delete_extension_task($data, true);
        CM::delete_config_by_course($event->courseid);
    }
}
