<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package    block_ned_teacher_tools
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


namespace block_ned_teacher_tools\output;

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\course_users_status as TT_status;
use block_ned_teacher_tools\output\menu_bar as MB;

require_once('deadline_manager_report_overview.php');

defined('MOODLE_INTERNAL') || die();

/** @var \stdClass $CFG */
require_once($CFG->dirroot . "/lib/completionlib.php");


class course_completion_status_manager extends deadline_manager_report_overview
{

    public function __construct()
    {
        parent::__construct(null, [], null, [], null, null, new \stdClass());
    }

    /**
     * Export page contents for template
     *
     * @param \renderer_base $output
     *
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output)
    {
        global $USER, $PAGE;

        $capabilities = [
            'moodle/grade:viewall',
        ];

        $data = new \stdClass();
        $data->overview_all = true;
        $show_inactive = optional_param('block_ned_teacher_tools_show_inactive', false, PARAM_BOOL);
        $data->canmanagegroups = false;
        $courses = is_siteadmin() ? get_courses() : enrol_get_all_users_courses($USER->id,false,'*');

        foreach ($courses as $course) {
            if ($course->format == 'site') {
                continue;
            }
            $course_context = \context_course::instance($course->id);
            if (!has_any_capability($capabilities, $course_context)) {
                continue;
            }

            list($show_inactive, $allgroups, $group, $groupid, $allstudents, $enrolledusers, $user, $userid) =
                MB::get_showinactive_groups_group_groupid_allstudents_students_user($course, $show_inactive, 0, 0, true);
            if (empty($allgroups)) {
                continue;
            }
            $this->_course = $course;
            $this->_context = $course_context;
            $this->_group = $group;
            $this->_groups = $allgroups;
            $this->_enrolledusers = $enrolledusers;
            $this->_user = $user;
            $this->_pageparams = [];

            $cus = new TT_status($course->id);
            $enable_on_course = $cus->enable_on_course();
            $completion_criteria_type_grade = 0;
            $completion_criteria_type_role = 0;
            $completion_criteria_type_activity = 0;
            if ($enable_on_course) {
                $courseobj = get_course($course->id);
                $completioninfo = new \completion_info($courseobj);
                $cr = $completioninfo->get_criteria(COMPLETION_CRITERIA_TYPE_ACTIVITY);
                $completion_criteria_type_activity = count($cr) ?? 0;
                $cr = $completioninfo->get_criteria(COMPLETION_CRITERIA_TYPE_ROLE);
                $completion_criteria_type_role = count($cr) ?? 0;
                $cr = $completioninfo->get_criteria(COMPLETION_CRITERIA_TYPE_GRADE);
                $completion_criteria_type_grade = count($cr) ?? 0;
            }

            $usersid = array_column($this->_enrolledusers, 'id');
            $count_statuses = $cus->get_count_users_in_statuses_by_course($usersid);

            $course_metadata = block_ned_teacher_tools_get_course_metadata($course->id);
            $coursetype = $course_metadata['course_type']['export_value'] ?? '';

            $badge_code = $cus->get_course_badge_code();
            $badgeurl = '';
            if (!empty($badge_code) && $badge = $cus->get_badge_by_code($badge_code)) {
                $badgeurl = new \moodle_url('/badges/overview.php', ['id' => $badge->id]);
            }

            $completioncriteriaurl = '';
            if (has_capability('moodle/course:update', $course_context)) {
                $completioncriteriaurl = new \moodle_url('/course/completion.php', ['id' => $course->id]);
            }
            $course_data = (object)[
                'shortname' => $course->shortname,
                'fullname' => $course->fullname,
                'url' => new \moodle_url('/course/view.php', ['id' => $course->id]),
                'coursetype' => $coursetype,
                'badgecode' => $badge_code,
                'badgeurl' => $badgeurl,
                'csmon' => $enable_on_course,
                'completioncriteriaurl' => $completioncriteriaurl,
                'completioncriteria' => [
                    'grade' => $completion_criteria_type_grade,
                    'role' => $completion_criteria_type_role,
                    'activity' => $completion_criteria_type_activity
                ],
                'countusersstatusesurl' => new \moodle_url(NED\PLUGIN_URL.'progress_report.php', ['courseid' => $course->id]),
                'countusersstatuses' => [
                    'in_progress' => $count_statuses[$cus::STATUS_IN_PROGRESS] ?? 0,
                    'waiting_for_final_grade' => $count_statuses[$cus::STATUS_WAITING_FOR_FINAL_GRADE] ?? 0,
                    'pass' => $count_statuses[$cus::STATUS_PASS] ?? 0,
                    'fail' => $count_statuses[$cus::STATUS_FAIL] ?? 0,
                    'waiting_for_internal_review' => $count_statuses[$cus::STATUS_WAITING_FOR_INTERNAL_REVIEW] ?? 0,
                ]
            ];

            $data->courses[] = $course_data;
        }

        $show_inactive = optional_param(MB::PAR_SHOWINACTIVE,false,PARAM_BOOL);
        $data->inactivecheckbox = MB::show_inactive_checkbox($PAGE->url, $show_inactive, MB::PAR_SHOWINACTIVE);
        $data->ishide = empty($data->courses);
        return $data;
    }
}
