<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Deadline Manager Header
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


namespace block_ned_teacher_tools\output;

defined('MOODLE_INTERNAL') || die();

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;
use block_ned_teacher_tools\deadline_manager as DM;
use block_ned_teacher_tools\output\menu_bar as MB;
use local_kica\helper;

/**
 * Class deadline_manager_report_user - overview by the single user
 *
 * @package block_ned_teacher_tools\output
 */
class deadline_manager_report_user extends deadline_manager_report {

    /**
     * Export page contents for template
     * @param \renderer_base $output
     *
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output) {
        $data = new \stdClass();

        $data->contextid = $this->_context->id;
        if (empty($this->_user)) {
            return $data;
        }

        $groupusers = $this->_enrolledusers;
        if (!isset($groupusers[$this->_user->id])) {
            return $data;
        }

        $dm_entity = DM::get_dm_entity($this->_course, $this->_group, $this->_user);

        if (helper::iskicaready($this->course->id)) {
            $gradebookurl = new \moodle_url('/local/kica/grade_user.php', [MB::PAR_COURSE => $this->course->id, MB::PAR_USER => $this->user->id]);
        } else {
            $gradebookurl = new \moodle_url('/grade/report/user/index.php', ['userid' => $this->user->id, 'id' => $this->course->id]);
        }
        $data->gradebookurl = $gradebookurl->out(false);

        $can_award_extension_after_last_activity = $dm_entity->can_award_extension_after_last_activity();

        foreach ($dm_entity->iterate() as $cmid => $dma){
            if (!$dma->is_enabled()) continue;

            $row = $dma->get_row();
            $row->userid = $this->user->id;
            // Activity grade.
            $row->activitygrade = $dma->get_grade();
            $row->gradeurl = $dma->get_grade_url();
            $row->submittedontime = 0;
            $row->misseddeadline = 0;

            if (empty($row->raw_deadline)){
                $row->numberofextensions = 0;
                $row->showextensionicon = false;
                $row->can_add_extension = false;
            } else {
                [, $numberofextensions, $can_add_extension, $showextensionicon] = $dma->get_activity_extension_data();
                $row->numberofextensions = $numberofextensions;
                $row->can_add_extension = $can_add_extension && $can_award_extension_after_last_activity;
                $row->showextensionicon = $showextensionicon;

                // Submitted on time & Missed Deadline.
                $timesubmit = $dma->get_submission_time();
                if ($timesubmit){
                    if ($timesubmit <= $row->raw_deadline) $row->submittedontime = 1;
                    else $row->misseddeadline = 1;
                } elseif ($row->raw_deadline < time()){
                    $row->misseddeadline = 1;
                }
            }

            $data->activities[] = $row;
        }

        return $data;
    }
}
