<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * NED Teacher Tools
 *
 * @package    block_ned_teacher_tools
 * @copyright  2019 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace block_ned_teacher_tools\output;

defined('MOODLE_INTERNAL') || die;

/**
 * NED Teacher Tools renderer
 *
 * @package    block_ned_teacher_tools
 * @copyright  2019 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class renderer extends \plugin_renderer_base {
    /**
     * Return the header content for the block NED teacher tools.
     *
     * @param deadline_manager_header $header The deadline_manager_header renderable
     *
     * @return string HTML string
     * @throws \moodle_exception
     */
    public function render_deadline_manager_header(deadline_manager_header $header) {
        return $this->render_from_template('block_ned_teacher_tools/deadline_manager_header', $header->export_for_template($this));
    }

    public function render_deadline_manager_report_overview(deadline_manager_report_overview $report) {
        return $this->render_from_template('block_ned_teacher_tools/deadline_manager_report_overview', $report->export_for_template($this));
    }

    public function render_deadline_manager_report_overview_all(deadline_manager_report_overview_all $report) {
        return $this->render_from_template('block_ned_teacher_tools/deadline_manager_report_overview', $report->export_for_template($this));
    }

    public function render_course_completion_status_manager(course_completion_status_manager $report) {
        return $this->render_from_template('block_ned_teacher_tools/course_completion_status_manager', $report->export_for_template($this));
    }

    public function render_course_completion_status_manager_users(course_completion_status_manager_users $report) {
        return $this->render_from_template('block_ned_teacher_tools/course_completion_status_manager_users', $report->export_for_template($this));
    }

    public function render_deadline_manager_report_group(deadline_manager_report_group $report) {
        return $this->render_from_template('block_ned_teacher_tools/deadline_manager_report_group', $report->export_for_template($this));
    }

    public function render_deadline_manager_report_user_overview(deadline_manager_report_user_overview $report) {
        return $this->render_from_template('block_ned_teacher_tools/deadline_manager_report_user_overview', $report->export_for_template($this));
    }

    public function render_menu_bar(menu_bar $widget){
        return $this->render_from_template('block_ned_teacher_tools/menu_bar', $widget->export_for_template($this));
    }
}
