<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @subpackage NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\task;

use block_ned_teacher_tools\grading_tracker as GT;
use block_ned_teacher_tools\shared_lib as SH;

defined('MOODLE_INTERNAL') || die;
require_once(__DIR__. '/../../lib.php');

/**
 * Trait adhoc_base_crongt
 * It's base trait for adhoc GT crones
 *
 * @package block_ned_teacher_tools\task
 */
class adhoc_base_crongt extends \local_ned_controller\task\base_adhoc_task {
    use \local_ned_controller\task\base_task;

    /**
     * If return false, task will not execute
     *
     * @return bool
     */
    public function can_execute(){
        $config = SH::get_config();
        if (!$config->crongt_enable){
            static::print('crongt is not enable, pass.');
            return false;
        }

        return true;
    }

    /**
     * Process custom data before saving it into the task
     *
     * @param array|mixed $custom_data
     *
     * @return array|mixed
     */
    static protected function _process_adding_custom_data($custom_data=[]){
        return $custom_data;
    }

    /**
     * Print log text about adding task
     *
     * @param string      $name - name of task
     * @param int|numeric $time_delay - time delay of task starting, in minutes
     * @param array|mixed $custom_data - some other data
     * @param static|null $task - added task
     *
     * @return void
     * @noinspection PhpUnusedParameterInspection
     */
    static protected function _print_adding_result($name, $time_delay, $custom_data, $task){
        if ($time_delay){
            static::print("Next run $name through $time_delay minutes.");
        } else {
            static::print("Queue $name task (zero delay).");
        }
    }

    /**
     * Base adding GT cron task
     *
     * @param int|numeric $multiplier
     * @param array|mixed $custom_data
     * @param bool        $check_same_tasks
     * @param null|static $task
     *
     * @return mixed|static|null
     */
    static protected function _crongt_add_new_job($multiplier=1, $custom_data=[], $check_same_tasks=false, $task=null){
        if ($check_same_tasks){
            if (static::has_same_tasks_warning()){
                return null;
            }
        }

        $task = $task ?? new static();
        $time_delay = 0;
        if ($multiplier > 0){
            $config = GT::get_config();
            $time_delay = $multiplier*$config->crongt_delay;
        }

        $custom_data = static::_process_adding_custom_data($custom_data);
        if (!empty($custom_data)){
            $task->set_custom_data($custom_data);
        }
        static::_add_new_job($task, $time_delay*MINSECS, !$check_same_tasks);
        static::_print_adding_result($task->get_name(), $time_delay, $custom_data, $task);

        return $task;
    }

    /**
     * Queue new task
     * Use it instead of just_add_new_job
     *
     * @param int|numeric $multiplier
     * @param array|mixed $custom_data
     * @param bool        $check_same_tasks
     * @param null|static $task
     *
     * @return mixed|static|null
     */
    static public function add_new_job($multiplier=1, $custom_data=[], $check_same_tasks=false, $task=null){
        return static::_crongt_add_new_job($multiplier, $custom_data, $check_same_tasks, $task);
    }
}
