<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Deadline Manager Header
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\task;

use core_plugin_manager;

defined('MOODLE_INTERNAL') || die();

class assign_student_role_to_cts extends \core\task\scheduled_task {

    public function get_name() {
        return get_string('assignstudentroletocts', 'block_ned_teacher_tools');
    }

    public function execute() {
        global $DB;

        $student = $DB->get_record('role', ['shortname' => 'student']);
        $ct = $DB->get_record('role', ['shortname' => 'classroom-teacher']);

        if (!$student && !$ct) {
            return true;
        }

        $sql = "SELECT ci.itemid, cm.course
                  FROM {tag_instance} ci
                  JOIN {tag} t
                    ON ci.tagid = t.id
                  JOIN {course_modules} cm
                    ON ci.itemid = cm.id
                 WHERE ci.itemtype = 'course_modules'
                   AND t.name = 'ct-upload'
                   AND cm.deletioninprogress = 0";

        $rs = $DB->get_recordset_sql($sql);

        foreach ($rs as $data) {
            if ($course = $DB->get_record('course', ['id' => $data->course])) {
                $coursecontext = \context_course::instance($course->id, MUST_EXIST);
                $modulecontext = \context_module::instance($data->itemid, MUST_EXIST);
                $sql = "SELECT u.* 
                          FROM {role_assignments} ra
                          JOIN {user} u
                            ON ra.userid = u.id
                         WHERE ra.roleid = ?
                           AND ra.contextid = ?
                           AND u.deleted = 0 
                           AND u.suspended = 0";
                if ($users = $DB->get_records_sql($sql, [$ct->id, $coursecontext->id])) {
                    foreach ($users as $user) {
                        role_assign($student->id, $user->id, $modulecontext);
                    }
                }
            }
        }
        $rs->close();

        return true;
    }
}