<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @subpackage NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\task;

use block_ned_teacher_tools\shared_lib as SH;
use local_ned_controller\task\base_task;

defined('MOODLE_INTERNAL') || die();
require_once(__DIR__. '/../../lib.php');

/**
 * Class crongt_hourly_task
 *
 * @package block_ned_teacher_tools\task
 */
class crongt_hourly_task extends \core\task\scheduled_task {
    use base_task;

    static protected $_added_tasks = 0;

    /**
     * Do the job.
     *
     * @param array|object|base_task|null $task_or_data
     *
     * @return void
     */
    static public function do_job($task_or_data=[]) {
        if (static::is_maple_warning()) return;

        $config = SH::get_config();
        if (!$config->crongt_enable){
            static::print('crongt is not enable, pass.');
            return;
        }

        $server_timezone = SH::NED_TIMEZONE;
        $server_date = SH::get_datetime_by_timestamp(null, $server_timezone);
        $now_h = (int)$server_date->format('G');

        // check update crones
        $check_h = (int)$config->crongt_hour;
        if ($now_h === $check_h){
            static::add_gt_course_update($config);
        } else {
            static::print("Now is $now_h o'clock ($server_timezone), and GM update starts at $check_h o'clock ($server_timezone), pass.");
        }

        // check notify crones
        $check_h = (int)$config->crongt_notify_hour;
        if ($now_h === $check_h){
            static::add_gt_notify_update($config);
        } else {
            static::print("Now is $now_h o'clock ($server_timezone), and GM notify starts at $check_h o'clock ($server_timezone), pass.");
        }
    }

    /**
     * Add gt_course_update job in query
     * Return true, if added, false otherwise
     *
     * @param \stdClass|null $config
     *
     * @return bool
     */
    static public function add_gt_course_update($config=null){
        $config = $config ?? SH::get_config();

        if (!$config->crongt_enable){
            static::print('adhoc_crongt_course_update is not enable, pass.');
            return false;
        }

        $res = (bool)adhoc_crongt_course_update::add_new_job(static::$_added_tasks, null, true);
        static::$_added_tasks += (int)$res;

        return $res;
    }

    /**
     * Add adhoc_crongt_notify job in query
     * Return true, if added, false otherwise
     *
     * @param \stdClass|null $config
     *
     * @return bool
     */
    static public function add_gt_notify_update($config=null){
        $config = $config ?? SH::get_config();

        if (!$config->crongt_enable || !$config->crongt_notify_enable){
            static::print('adhoc_crongt_notify is not enable, pass.');
            return false;
        }

        $res = (bool)adhoc_crongt_notify::add_new_job(static::$_added_tasks, [], true);
        static::$_added_tasks += (int)$res;

        return $res;
    }
}
