<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Unlimited enrollment
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace block_ned_teacher_tools\task;

use core_plugin_manager;

defined('MOODLE_INTERNAL') || die();

class unlimited_enrollment extends \core\task\scheduled_task {

    public function get_name() {
        return get_string('unlimitedenrollmenttask', 'block_ned_teacher_tools');
    }

    public function execute() {
        global $DB;

        $sql = "SELECT ue.id, ue.userid, e.enrol, e.courseid
                  FROM {user_enrolments} ue
                  JOIN {enrol} e 
                    ON ue.enrolid = e.id
                  JOIN (SELECT ra.id, ra.userid, r.shortname, cx.instanceid courseid
                          FROM {role_assignments} ra
	                      JOIN {role} r 
                            ON ra.roleid = r.id
                          JOIN {context} cx
                            ON ra.contextid = cx.id
                         WHERE r.shortname IN ('r-da','r-sa','classroom-teacher','online-teacher') 
                           AND cx.contextlevel = ?) r 
                    ON ue.userid = r.userid 
                   AND e.courseid = r.courseid
		         WHERE ue.timeend > 0                 
                   AND e.status = 0";

        $rs = $DB->get_recordset_sql($sql, [CONTEXT_COURSE]);
        foreach ($rs as $enrollment) {
            $rec = new \stdClass();
            $rec->id = $enrollment->id;
            $rec->timeend = 0;
            $DB->update_record('user_enrolments', $rec);
        }
        $rs->close();

        return true;
    }
}