<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$capabilities = array(
    'block/ned_teacher_tools:myaddinstance' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_SYSTEM,
        'archetypes' => array(
            'editingteacher' => CAP_ALLOW,
            'manager' => CAP_ALLOW
        ),

        'clonepermissionsfrom' => 'moodle/my:manageblocks'
    ),

    'block/ned_teacher_tools:addinstance' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_BLOCK,
        'archetypes' => array(
            'editingteacher' => CAP_ALLOW,
            'manager' => CAP_ALLOW
        ),

        'clonepermissionsfrom' => 'moodle/site:manageblocks'
    ),


    'block/ned_teacher_tools:viewblock' => array(

        'captype' => 'read',
        'contextlevel' => CONTEXT_BLOCK,
        'archetypes' => array(
            'user' => CAP_PREVENT,
            'guest' => CAP_PREVENT,
            'student' => CAP_PREVENT,
            'teacher' => CAP_ALLOW,
            'editingteacher' => CAP_ALLOW,
            'manager' => CAP_ALLOW
        )
    ),

    'block/ned_teacher_tools:viewreadonly' => array(

        'captype' => 'read',
        'contextlevel' => CONTEXT_BLOCK,
        'archetypes' => array(
            'user' => CAP_PREVENT,
            'guest' => CAP_PREVENT,
            'student' => CAP_PREVENT,
            'teacher' => CAP_ALLOW,
            'editingteacher' => CAP_ALLOW,
            'manager' => CAP_ALLOW
        )
    ),

    'block/ned_teacher_tools:viewkicagradebook' => array(

        'captype' => 'read',
        'contextlevel' => CONTEXT_BLOCK,
        'archetypes' => array(
            'user' => CAP_PREVENT,
            'guest' => CAP_PREVENT,
            'student' => CAP_PREVENT,
            'teacher' => CAP_ALLOW,
            'editingteacher' => CAP_ALLOW,
            'manager' => CAP_ALLOW
        )
    ),

    'block/ned_teacher_tools:view_all_groups' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE
    ),

    'block/ned_teacher_tools:view_own_groups' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE
    ),

    'block/ned_teacher_tools:manage_group_requirements' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:manage_group_deadlines' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:manage_user_requirements' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:manage_user_deadlines' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:add_extension' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:add_extension_sa' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:view_extension_detail' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:manage_extensions' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),

    // ignore some of the DM extension limits
    'block/ned_teacher_tools:ignore_max_extension_limit' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:ignore_expired_dm_restriction' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:deadlineviewonly' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:manageactivitiessettings' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
        'archetypes' => array(
            'user' => CAP_PREVENT,
            'guest' => CAP_PREVENT,
            'student' => CAP_PREVENT,
            'teacher' => CAP_PREVENT,
            'editingteacher' => CAP_PREVENT,
            'manager' => CAP_PREVENT
        )
    ),

    'block/ned_teacher_tools:overriderestrictions' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:managecompletionstatus' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),

    'block/ned_teacher_tools:seecoursegradewhilewaitingforfinalgrade' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE
    ),

    'block/ned_teacher_tools:extendclassstudentenddate' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE
    ),

    'block/ned_teacher_tools:canawarddeadlineextensionafterlastactivity' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE
    ),

    'block/ned_teacher_tools:gradingtracker_seeown' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_SYSTEM,
    ),
    'block/ned_teacher_tools:gradingtracker_seeall' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_SYSTEM,
    ),
    'block/ned_teacher_tools:gradingtracker_canhide' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_SYSTEM,
    ),
    'block/ned_teacher_tools:view_timezone_menu' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:removesubmissiondata' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:allowresubmission' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:allowungraded2draft' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:viewgradestats' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:viewcttoggle' => array(
        'captype' => 'read',
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:ignore_extensions_after_ccompletion_limit' => array(
        'captype' => 'write',
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:canviewcta' => array(
        'captype' => 'read',
        'riskbitmask' => RISK_PERSONAL,
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:cangradecta' => array(
        'captype' => 'write',
        'riskbitmask' => RISK_PERSONAL,
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:spcanseegrader' => array(
        'captype' => 'read',
        'riskbitmask' => RISK_PERSONAL,
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:canviewrapsreport' => array(
        'captype' => 'read',
        'riskbitmask' => RISK_PERSONAL,
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:canviewpsandaiccolumns' => array(
        'captype' => 'read',
        'riskbitmask' => RISK_PERSONAL,
        'contextlevel' => CONTEXT_COURSE,
    ),
    'block/ned_teacher_tools:viewclassesmenubar' => array(
        'captype' => 'read',
        'riskbitmask' => RISK_PERSONAL,
        'contextlevel' => CONTEXT_COURSE,
    ),
);