<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Deadline Manager
 *
 * @package    block_ned_teacher_tools
 * @copyright  Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools\shared_lib as SH;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once(__DIR__.'/lib.php');
require_once($CFG->dirroot.'/course/classes/category.php');
require_once($CFG->dirroot.'/blocks/ned_teacher_tools/classes/output/deadline_manager_report_overview_all.php');

$category_id = optional_param('category', -1, PARAM_INT);

require_login();
$context = SH::ctx();
$capabilities = ['view_all_groups', 'view_own_groups', 'deadlineviewonly'];

if (!SH::has_any_capability($capabilities, $context)) {
    SH::print_error('nopermissions', 'error', '', get_string('checkpermissions', 'core_role'));
}

// Set the url.
$thispageurl = SH::url('~/deadline_manager_overview_all.php');
$title = SH::str('deadlinemanager');
$output = '';

$PAGE->set_context($context);
$PAGE->set_url($thispageurl);
$PAGE->set_title($title);
$PAGE->set_heading($title);

SH::$C::js_call_amd('add_sorter', 'add_sort', ['table.nedtable']);

$PAGE->navbar->add(SH::str('pluginname'));
$PAGE->navbar->add($title);

$categorieslist = core_course_category::make_categories_list();
$def_cats = ['-1' => get_string('none'), '0' => get_string('all')];
$all_cats = $def_cats + $categorieslist;
$category_id = SH::isset_key($all_cats, $category_id, -1);

$select = new single_select($thispageurl, 'category', $all_cats, $category_id, null);
$select->label = get_string('category');
$output .= SH::div(SH::render($select), 'category_selector');

echo $OUTPUT->header();

$output .= SH::get_renderer()->render(new \block_ned_teacher_tools\output\deadline_manager_report_overview_all($category_id));
echo $output;
echo $OUTPUT->footer();
