<?php

use block_ned_teacher_tools as NED;
use block_ned_teacher_tools\shared_lib as SH;

require_once('../../config.php');
require_once (__DIR__ .'/lib.php');

require_login();
if (!is_siteadmin($USER)) {
    SH::print_error('Permission error!');
}
$action = optional_param('action', '', PARAM_TEXT);
$type = optional_param('type', NED\RESUBMISSIONS_ALL, PARAM_INT);
$gghid = optional_param('gghid', 0, PARAM_INT);
$courseid = optional_param('courseid', 0, PARAM_INT);

if (!in_array($type, NED\RESUBMISSIONS_KEYS)){
    SH::print_error('Wrong type!');
}

$base_url = new moodle_url(NED\PLUGIN_URL . 'unused_resubmissions_manager.php');
$parent_url = new moodle_url('/admin/settings.php', ['section' => 'blocksettingned_teacher_tools']);
$page_title = NED\str('unused_resubmissions_manager');

//$PAGE->add_body_class('zoomin');
$PAGE->set_pagelayout('admin');
$PAGE->set_context(context_system::instance());
$PAGE->set_url($base_url);
$PAGE->navbar->add(get_string('administrationsite'), new moodle_url('/admin/search.php'));
$PAGE->navbar->add(NED\str('pluginname'), $parent_url);
$PAGE->navbar->add($page_title, $base_url);
$output = '';

$made_by_rm = null;
if (!empty($action) && $type != NED\RESUBMISSIONS_ALL){
    $made_by_rm = $type >= NED\RESUBMISSIONS_MADE_BY_RM && $type < NED\RESUBMISSIONS_MADE_NOT_BY_RM;
}

$get_unused_resubmissions_text = function($key, $course_data, $record_data){
    $a = (object)['records_count' => count($record_data), 'courses_count' => count($course_data)];
    return NED\str('unusedresubmissions_' . $key, $a);
};
$onclick_remove = ['onclick' => 'return confirm("'.NED\str('removeresubmissionswarn').'");'];

list($courses_by_cat, $records_by_cat) = NED\get_unused_resubmissions($made_by_rm);

switch ($action){
    case '':
        // default page
        $keys = [NED\RESUBMISSIONS_ALL => [
            NED\RESUBMISSIONS_MADE_BY_RM => [
                NED\RESUBMISSIONS_MADE_BY_RM_CONTROLLED_BY_RM => false,
                NED\RESUBMISSIONS_MADE_BY_RM_CONTROLLED_NOT_BY_RM => false,
            ],
            NED\RESUBMISSIONS_MADE_NOT_BY_RM => [
                NED\RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_BY_RM => false,
                NED\RESUBMISSIONS_MADE_NOT_BY_RM_CONTROLLED_NOT_BY_RM => false,
            ]
        ]];

        $get_li = function($key, $course_data, $record_data, $n=0) use ($get_unused_resubmissions_text, $base_url, $onclick_remove){
            $txt = $get_unused_resubmissions_text($key, $course_data, $record_data);
            $buttons = '';
            if (!empty($record_data)){
                $show_url = new moodle_url($base_url, ['action' => 'show', 'type' => $key]);
                $remove_url = new moodle_url($base_url, ['action' => 'remove', 'type' => $key]);
                $buttons = html_writer::span(
                    NED\link($show_url, NED\str('showdetails'), 'btn btn-primary') .
                    NED\link($remove_url, NED\str('remove'), 'btn btn-secondary btn-remove', $onclick_remove),
                    'unused-resubmissions-control'
                );
            }
            return html_writer::tag('li', $txt . $buttons,
                ['class' => 'unused-resubmissions-label', 'data-nesting' => $n]);
        };

        $loop = function($keys, $n=0) use (&$loop, $get_li, $courses_by_cat, $records_by_cat){
            $res = html_writer::start_tag('ul', ['data-nesting' => $n]);
            foreach ($keys as $key => $item){
                $res .= $get_li($key, $courses_by_cat[$key], $records_by_cat[$key], $n);
                if ($item){
                    $res .= $loop($item, $n+1);
                }
            }
            $res .= html_writer::end_tag('ul');
            return $res;
        };

        $output .= html_writer::start_div('unused-resubmissions-statistics');
        $output .= $loop($keys);
        $output .= html_writer::end_div();
        break;
    case 'show':
        // show table with specific type
        $page_title = NED\str('details');
        $url = new moodle_url($base_url, ['action' => 'show', 'type' => $type]);
        $parent_url = new moodle_url($base_url);
        $PAGE->navbar->add($page_title, $url);
        $courses_data = $courses_by_cat[$type];
        $records_data = $records_by_cat[$type];
        $output .= html_writer::div($get_unused_resubmissions_text($type, $courses_data, $records_data), 'unused-resubmissions-title');
        if (empty($courses_data)){
            break;
        }

        $table = new html_table();
        $table->id = 'datatable';
        $table->attributes = ['class' => 'ur-table nedtable'];
        $classes = ['ur-student', 'ur-course', 'ur-activityname', 'ur-daysopen', 'ur-studentprogress', 'ur-action', 'ur-madebyrm', 'ur-controlledbyrm'];
        $c = 0;
        $table->head = [
            NED\cell(NED\str('student'), $classes[$c++]),
            NED\cell(get_string('course'), $classes[$c++]),
            NED\cell(NED\str('activityname'), $classes[$c++]),
            NED\cell(NED\str('daysopen'), $classes[$c++]),
            NED\cell(NED\str('studentprogress'), $classes[$c++] . ' sorter-false'),
            NED\cell(NED\str('action'), $classes[$c++] . ' sorter-false'),
            NED\cell(NED\str('madebyrm'), $classes[$c++]),
            NED\cell(NED\str('controlledbyrm'), $classes[$c++])
        ];
        $clink = function($url_params='', $text='', $cell_classes='', $attr=[]){
            $attr = array_merge($attr, ['target' => '_blank']);
            return NED\cell(NED\link($url_params, $text, '', $attr), $cell_classes);
        };
        $bool_cell = function($val, $class){
            return  NED\cell($val ? NED\fa('fa-check') : NED\fa('fa-times'), $class, ['data-sort-value' => (int)$val]);
        };
        $now = time();
        $days_from_timecreated = function($timecreated) use ($now){
            $delta = $now - $timecreated;
            return (int)floor($delta / DAYSECS);
        };
        foreach ($records_data as $record){
            $c = 0;
            $cells = [];
            $cells[] = $clink(['/user/view.php', ['id' => $record->userid, 'course' => $record->courseid]], $record->username, $classes[$c++]);
            $cells[] = $clink(['/course/view.php', ['id' => $record->courseid]], $record->course, $classes[$c++]);
            $cells[] = $clink(['/mod/assign/view.php', ['id' => $record->cmid]], $record->assign, $classes[$c++]);
            $cells[] = NED\cell($days_from_timecreated($record->timecreated), $classes[$c++]);
            $cells[] = $clink(['/blocks/ned_teacher_tools/student_progress.php', ['id' => $record->courseid, 'u' => $record->userid]],
                NED\str('open'), $classes[$c++]);
            $cells[] = NED\cell(NED\link([$base_url, ['action' => 'remove', 'type' => $type, 'gghid' => $record->id]],
                NED\str('remove'), '', $onclick_remove), $classes[$c++]);
            $cells[] = $bool_cell($record->made_by_rm, $classes[$c++]);
            $cells[] = $bool_cell($record->controlled_rm, $classes[$c++]);

            $table->data[] = NED\row($cells, '', ['data-course' => $record->courseid]);
        }
        $output .= NED\link($parent_url, get_string('back'), 'btn btn-primary');
        $button_rem = NED\link([$base_url, ['action' => 'remove', 'type' => $type]], NED\str('remove'),
            'btn btn-secondary', ['id' => 'ur-remove-by-course', 'data-onclick' => NED\str('removeresubmissionswarn')]);
        $name_select = 'select_course';
        $filter = html_writer::label(get_string('courses'), $name_select) .
            html_writer::select((['all' => get_string('all')] + $courses_data), $name_select, 'all', [], ['id' => $name_select]) .
            html_writer::div($button_rem .
                html_writer::span(NED\str('unusedresubmissions') . ': ' . html_writer::span('-', 'ur-count-value')),
                'ur-filter-remove');
        $output .= html_writer::div($filter, 'ur-filter');
        $output .= html_writer::table($table);
        SH::$C::js_call_amd('add_sorter', 'add_sort',
            ['#page-blocks-ned_teacher_tools-unused_resubmissions_manager .nedtable']);
        $PAGE->requires->js_call_amd(NED\PLUGIN_NAME . '/unused_resubmissions_manager', 'init');
        break;
    case 'remove':
        // remove data and redirect
        $url = new moodle_url($base_url);
        $check_status = 'reopened';
        $error_text = '';
        $done = 0;
        if ($gghid && isset($records_by_cat[NED\RESUBMISSIONS_ALL][$gghid])){
            $url = new moodle_url($base_url, ['action' => 'show', 'type' => $type]);
            $record = $records_by_cat[NED\RESUBMISSIONS_ALL][$gghid];
            $done = (int) NED\remove_last_submission($record->cmid, $record->userid, $check_status, $record->courseid);
        } elseif (!$gghid){
            if ($courseid){
                $url = new moodle_url($base_url, ['action' => 'show', 'type' => $type]);
            }
            $records_data = $records_by_cat[$type];
            foreach ($records_data as $record){
                if ($courseid && $record->courseid != $courseid){
                    continue;
                }
                $done += (int) NED\remove_last_submission($record->cmid, $record->userid, $check_status, $record->courseid);
            }
        } else {
            $error_text = "\"There is wrong gghid = $gghid\"";
        }
        if ($done){
            redirect($url, NED\str('unusedresubmissions_removed_successfully', ['count' => $done]),
                null,\core\output\notification::NOTIFY_SUCCESS);
        } else {
            redirect($url, NED\str('unusedresubmissions_removed_error', ['error' => $error_text]),
                null,\core\output\notification::NOTIFY_ERROR);
        }
        die;
}

$PAGE->set_title($page_title);
$PAGE->set_heading($page_title);
$output .= NED\link($parent_url, get_string('back'), 'btn btn-secondary');

echo $OUTPUT->header();
echo $output;
echo $OUTPUT->footer();
