<?php
/**
 * @package    block_ned_teacher_tools
 * @subpackage NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools\shared_lib as SH;

define('NO_OUTPUT_BUFFERING', true);

require_once('../../config.php');
require_once(__DIR__ . '/lib.php');

require_login();
$title = SH::str('updatescripts');
$url = SH::url('~/update_scripts.php');
$PAGE->set_context(\context_system::instance());
$PAGE->set_url($url);
$PAGE->set_title($title);
$PAGE->navbar->add($title, $url);
$PAGE->set_heading($title);

$mform = new block_ned_teacher_tools\form\update_scripts();
if ($mform->is_cancelled()) {
    redirect($url);
}

echo $OUTPUT->header();
if (is_siteadmin()){
    if ($data = $mform->get_data()) {
        if ($mform->do_action($data, true)){
            SH::redirect_continue($url, SH::str('updatedsuccessfully'), SH::NOTIFY_SUCCESS);
        } else {
            SH::redirect_continue($url, SH::str('unexpectederror'), SH::NOTIFY_ERROR);
        }
    } else {
        echo SH::div(SH::str('all_warning'), 'mb-5');
        echo $mform->draw();
    }
} else {
    SH::print_error('nopermissions', 'error', '', '');
}
echo $OUTPUT->footer();
