<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    format_ned
 * @subpackage NED
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

namespace format_ned\form;

defined('MOODLE_INTERNAL') || die;

use format_ned\shared_lib as NED;

/** @var \stdClass $CFG */
require_once($CFG->libdir.'/formslib.php');
require_once($CFG->libdir.'/completionlib.php');
require_once($CFG->dirroot.'/course/edit_form.php');

/**
 * Class format_ned_course_edit_form
 *
 * @see \format_ned::course_format_options() for course settings
 */
class course_edit_form extends \moodleform {

    public function definition() {
        $mform = &$this->_form;

        $base_class = $mform->_attributes['class'] ?? '';
        $mform->_attributes['class'] = $base_class.' format_ned-course_edit_form';

        $mform->addElement('hidden', 'id', $this->_customdata['courseid']);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('header', 'nedformat', NED::str('format'));

        $mform->addElement('static', 'formatinfo', NED::str('formatinfo'),
            '<a target="_blank" href="//ned.ca/ned-format">ned.ca/ned-format</a>');

        if (is_siteadmin()) {
            $sitesettings = new \moodle_url('/admin/settings.php?section=formatsettingned');
            $mform->addElement('static', 'sitewidesettings', NED::str('sitewidesettings'),
                '<a href="'.$sitesettings.'">'.NED::str('opensitesettings').'</a>');
        }

        $choices = array(
            0 => NED::str('sectionformatmoodle'),
            1 => NED::str('sectionformatframed'),
            3 => NED::str('sectionformatframedformatted')
        );
        if (get_config('format_ned', 'framedsectionscustomheader') == 1) { // Show - see settings.php.
            $choices[2] = NED::str('sectionformatframedcustom');
        }
        $label = NED::str('sectionformat');
        $mform->addElement('select', 'sectionformat', $label, $choices);
        unset($choices);

        $mform->addElement('html', '<div id="nedsectionlocation">');
        $choices = array(
            0 => get_string('hide'),
            1 => NED::str('showsectionheader'),
            2 => NED::str('showsectionbody')
        );
        $label = NED::str('sectionnamelocation');
        $mform->addElement('select', 'sectionnamelocation', $label, $choices);
        unset($choices);
        $mform->disabledIf('sectionnamelocation', 'sectionformat', 'neq', 2);

        $choices = array(
            0 => NED::str('showsectionheader'),
            1 => NED::str('showsectionbody')
        );
        $label = NED::str('sectionsummarylocation');
        $mform->addElement('select', 'sectionsummarylocation', $label, $choices);
        unset($choices);
        $mform->disabledIf('sectionsummarylocation', 'sectionformat', 'neq', 2);
        $mform->addElement('html', '</div>');

        // List of colour presets.
        global $DB;
        $colourpresetitems = array(0 => NED::str('colourpresetformattheme'));
        if ($presets = $DB->get_records('format_ned_colour', null, null, 'id,name')) {
            foreach ($presets as $preset) {
                $colourpresetitems[$preset->id] = $preset->name;
            }
        } else {
            $colourpresetitems[1] = 'Embassy Green';
            $colourpresetitems[2] = 'Blues on Whyte';
            $colourpresetitems[3] = 'Grey Skies';
        }

        $mform->addElement('html', '<div id="managecolourpresets">');

        $label = NED::str('colourpreset');
        $mform->addElement('select', 'colourpreset', $label, $colourpresetitems);

        $mform->addElement('html', '</div>');

        $mform->addElement('header', 'nedformat', NED::str('othersettings'));

        $choices = array(
            1 => get_string('show'),
            3 => NED::str('showsection0editmode'),
            2 => NED::str('showonlysection0')
        );
        $label = NED::str('showsection0');
        $mform->addElement('select', 'showsection0', $label, $choices);
        unset($choices);

        $mform->addElement('hidden', 'nedsettingsform', 1);
        $mform->setType('nedsettingsform', PARAM_INT);

        // Block settings
        $mform->addElement('header', 'blocksettings', get_string('blocksettings', 'block'));

        $mform->addElement('select', 'config_block_show', NED::str('config_block_show'), NED::get_yesno_list());
        $mform->addElement('text', 'config_block_title', NED::str('config_block_title'));
        $mform->setType('config_block_title', PARAM_TEXT);

        $config_header_options = [];
        $config_header_desc = [];
        foreach (NED::HEADER_OPTIONS as $header_option){
            $config_header_options[$header_option] = NED::str('config_header_option_'.$header_option);
            $config_header_desc[$header_option] = NED::str('config_header_desc_'.$header_option);
        }
        $mform->addElement('select', 'config_header', NED::str('config_header'), $config_header_options);
        $this->_add_description_element(\html_writer::alist($config_header_desc));

        $params = ['style' => 'width: 100% !important; min-height: 200px;'];
        $mform->addElement('textarea', 'config_block_text', NED::str('config_block_text'), $params);
        $mform->setType('config_block_text', PARAM_TEXT);
        $this->_add_description_element(\local_ned_controller\output\custom_ned_menu\custom_ned_menu::get_menu_format_description());

        $this->add_action_buttons();
    }

    /**
     * Add static element, than positioned under fields (not under fields labels),
     *  which looks like field description
     *
     * @param string $text
     *
     * @return void
     */
    protected function _add_description_element($text){
        static $_i = 0;
        $el = &$this->_form->addElement('static', 'description_element_'.($_i++), '',
            NED::div($text, 'd-flex'));
        $el->_label = NED::HTML_SPACE; // make margin through label
    }
}
