<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    format_ned
 * @subpackage NED
 * @copyright  NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @developer  G J Barnard - {@link http://about.me/gjbarnard} and
 *                           {@link http://moodle.org/user/profile.php?id=442195}
 */

defined('MOODLE_INTERNAL') || die();

use format_ned\shared_lib as NED;

require_once(__DIR__. '/classes/format_ned.php');

/**
 * Implements callback inplace_editable() allowing to edit values in-place
 *
 * @param string $itemtype
 * @param int $itemid
 * @param mixed $newvalue
 *
 * @return \core\output\inplace_editable|null
 */
function format_ned_inplace_editable($itemtype, $itemid, $newvalue) {
    global $DB, $CFG;
    require_once($CFG->dirroot . '/course/lib.php');
    if ($itemtype === 'sectionname' || $itemtype === 'sectionnamenl') {
        $section = $DB->get_record_sql(
            'SELECT s.* FROM {course_sections} s JOIN {course} c ON s.course = c.id WHERE s.id = ? AND c.format = ?',
            array($itemid, 'ned'), MUST_EXIST);
        return course_get_format($section->course)->inplace_editable_update_section_name($section, $itemtype, $newvalue);
    }

    return null;
}

/**
 * @param navigation_node $parentnode
 * @param stdClass        $course
 * @param context_course  $context
 */
function format_ned_extend_navigation_course(navigation_node $parentnode, stdClass $course, context_course $context) {
    if (($course->format == 'ned') && (has_capability('format/ned:formatupdate', $context))) {
        $node = navigation_node::create(get_string('editnedformatsettings', 'format_ned'),
            new moodle_url('/course/format/ned/nedsettings.php', array('id' => $course->id)),
            navigation_node::TYPE_SETTING, null, null, new pix_icon('ned_icon',
            get_string('editnedformatsettings', 'format_ned'), 'format_ned'));
        $node->showinflatnavigation = true;
        $parentnode->add_node($node);
    }
}

/**
 * Add custom menu block to the course page, if settings are met
 * @noinspection PhpUnused
 */
function format_ned_before_http_headers(){
    global $PAGE;
    if ($PAGE->course == SITEID || empty($PAGE->get_where_theme_was_initialised())) return;

    $format = format_ned::get_active_format_ned();
    if (empty($format)) return;

    if (!$format->get_setting('config_block_show')) return;

    $menu = $format->get_menu();
    if (!$menu || $menu->is_empty()) return;

    $bc = new block_contents();
    $bc->title = $menu->get_header_menu_item()->get_format_title() ?:
        ($format->get_setting('config_block_title') ?: NED::str('config_block_title_default'));
    $bc->attributes = $menu->get_block_html_attributes();
    $bc->content = NED::render($menu);

    $PAGE->blocks->add_fake_block($bc, $PAGE->blocks->get_default_region());
}
