<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * NED Filter
 *
 * @package    filter
 * @subpackage NED
 * @copyright  2017 Michael Gardener mgardener@cissq.com
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

function filter_ned_sub($attributes, $content)
{
    global $DB, $USER;

    // Extract attributes.
    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (empty($USER->profile['subnumber'])) {
        return '';
    }

    if (!isset($value) && !isset($courselink)) {
        return '';
    }

    if (!empty($value)) {
        $usersubnumbers = explode(',', str_replace(' ', '', $USER->profile['subnumber']));
        $subnumbers = explode(',', str_replace(' ', '', $value));

        if (array_intersect($usersubnumbers, $subnumbers)) {
            return $content;
        }
    } else if (!empty($courselink)) {
        $ctx = \filter_ned::$filtercontext;

        if ($coursectx = $ctx->get_course_context(false)) {
            if ($DB->record_exists('capabilities', array('name' => 'filter/ned:viewcourselink' . $courselink))) {
                if (has_capability('filter/ned:viewcourselink' . $courselink, $coursectx)) {
                    return $content;
                }
            }
        }
    }

    return '';
}

function filter_ned_course_users($attributes) {

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (!isset($text)) {
        $text = get_string('ned-course-users-all', 'filter_ned');
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        $url = new moodle_url('/user/index.php', array('contextid' => $coursectx->id));
        return html_writer::link($url, $text);
    }

    return '';
}
function filter_ned_course_users_teachers($attributes) {

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (!isset($text)) {
        $text = get_string('ned-course-users-teachers', 'filter_ned');
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        $url = new moodle_url('/user/index.php', array('contextid' => $coursectx->id, 'roleid' => 3));
        return html_writer::link($url, $text);
    }

    return '';
}

function filter_ned_course_users_student($attributes) {

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (!isset($text)) {
        $text = get_string('ned-course-users-student', 'filter_ned');
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        $url = new moodle_url('/user/index.php', array('contextid' => $coursectx->id, 'roleid' => 5));
        return html_writer::link($url, $text);
    }

    return '';
}

function filter_ned_course_home($attributes) {
    global $DB;

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        $course = $DB->get_record('course', array('id' => $coursectx->instanceid));
        if (!isset($text)) {
            $text = get_string('ned-course-home', 'filter_ned', $course->shortname);
        }
        $url = new moodle_url('/course/view.php', array('id' => $course->id));
        return html_writer::link($url, $text);
    }

    return '';
}

function filter_ned_grades($attributes) {
    global $USER;

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        if (has_capability('gradereport/grader:view', $coursectx) && has_capability('moodle/grade:viewall', $coursectx)) {
            if (!isset($text)) {
                $text = get_string('ned-grades-grader', 'filter_ned');
            }
            $url = new moodle_url('/grade/report/grader/index.php', array('id' => $coursectx->instanceid));
            return html_writer::link($url, $text);
        } else if (has_capability('gradereport/user:view', $coursectx)) {
            if (!isset($text)) {
                $text = get_string('ned-grades-user', 'filter_ned');
            }
            $url = new moodle_url('/grade/report/user/index.php', array('id' => $coursectx->instanceid, 'userid' => $USER->id));
            return html_writer::link($url, $text);
        }
    }

    return '';
}

function filter_ned_progress_report($attributes) {

    $pluginman = core_plugin_manager::instance();
    if (!$pluginfo = $pluginman->get_plugin_info('block_fn_marking')) {
        return '';
    }

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (!isset($text)) {
        $text = get_string('ned-progress-report', 'filter_ned');
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        if (has_capability('moodle/grade:viewall', $coursectx)) {
            $url = new moodle_url('/blocks/fn_marking/progress_report.php', array('id' => $coursectx->instanceid));
            return html_writer::link($url, $text);
        }
    }

    return '';
}

function filter_ned_clink1($attributes) {

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (!isset($text)) {
        return '';
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        if (has_capability('filter/ned:viewcourselink1', $coursectx)) {
            if (!empty($link)) {
                return html_writer::link($link, $text);
            } else {
                return $text;
            }
        }
    }

    return '';
}
function filter_ned_clink2($attributes) {

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (!isset($text)) {
        return '';
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        if (has_capability('filter/ned:viewcourselink2', $coursectx)) {
            if (!empty($link)) {
                return html_writer::link($link, $text);
            } else {
                return $text;
            }
        }
    }

    return '';
}
function filter_ned_clink3($attributes) {

    if ($attributes) {
        foreach ($attributes as $var => $varvalue) {
            $$var = $varvalue;
        }
    }

    if (!isset($text)) {
        return '';
    }

    $ctx = \filter_ned::$filtercontext;

    if ($coursectx = $ctx->get_course_context(false)) {
        if (has_capability('filter/ned:viewcourselink3', $coursectx)) {
            if (!empty($link)) {
                return html_writer::link($link, $text);
            } else {
                return $text;
            }
        }
    }

    return '';
}