/**
 * gradedist.js
 *
 * @package
 * @author    Andreas Krieger
 * @copyright 2014-2018 Academic Moodle Cooperation {@link http://www.academic-moodle-cooperation.org}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("gradereport_gradedist/gradedist",["jquery","core/log","core/str","gradereport_gradedist/config"],(function($,log,str){var Gradedist=function(){};Gradedist.prototype.update=function(o){var data=JSON.parse(o.responseText);if(1==data.updateall){window.absolut=[],window.percent=[],$.map(data.letters,(function(letter){window.absolut.push(data.actdist[letter].count),window.percent.push(data.actdist[letter].percentage)}));var values=1==window.mode?window.percent:window.absolut;window.chart.data.datasets[0].data=values,window.chart.options.title.text=[data.title,""]}window.absolutnew=[],window.percentnew=[],$.map(data.letters,(function(letter){window.absolutnew.push(data.newdist[letter].count),window.percentnew.push(data.newdist[letter].percentage)})),instance.coverage(data);var newvalues=1==window.mode?window.percentnew:window.absolutnew;return window.chart.data.datasets[1].data=newvalues,window.chart.update(),!0},Gradedist.prototype.validate=function(){var error=!1,errdec=!1,errint=!1,errpre=!1,erremp=!1,errdecdiv=$("#b_decimals").first(),errintdiv=$("#b_interval").first(),errprediv=$("#b_predecessor").first(),decimals=/^\d+([.]\d{1,2})?$/,pre=100.01;return $.each(window.boundaries,(function(id,boundary){var value=boundary.value.replace(/,/g,".");""!=value?(decimals.test(value)||(errdec=!0),Number(value)>100&&(errint=!0),Number(value)>=Number(pre)&&(errpre=!0),pre=value):erremp=!0})),errdec?(errdecdiv.length||str.get_string("decimals","gradereport_gradedist").done((function(s){$("#boundary_error_container").first().append('<div class="b_error" id="b_decimals"><span>'+s+"</span></div>")})),error=!0):errdecdiv.length&&errdecdiv.remove(),errint?(errintdiv.length||str.get_string("interval","gradereport_gradedist").done((function(s){$("#boundary_error_container").first().append('<div class="b_error" id="b_interval"><span>'+s+"</span></div>")})),error=!0):errintdiv.length&&errintdiv.remove(),errpre?(errprediv.length||str.get_string("predecessor","gradereport_gradedist").done((function(s){$("#boundary_error_container").first().append('<div class="b_error" id="b_predecessor"><span>'+s+"</span></div>")})),error=!0):errprediv.length&&errprediv.remove(),window.submit.length&&window.submit.prop("disabled",error||erremp),$("#id_grp_export_export").prop("disabled",!1),!error},Gradedist.prototype.coverage=function(data){var error=!1,erremp=!1,errcov=0!=Number(data.newcoverage[0]),errcovdiv=$("#b_coverage").first();return $.each(window.boundaries,(function(id,boundary){""==boundary.value&&(erremp=!0)})),!erremp&&errcov?(errcovdiv.length||str.get_string("coverage","gradereport_gradedist").done((function(s){$("#boundary_error_container").first().append('<div class="b_error" id="b_coverage"><span>'+s+'</span><span class="newcoverage">'+data.newcoverage[0]+"/"+data.newcoverage[1]+"</span></div>")})),error=!0):errcovdiv.length&&errcovdiv.remove(),$(".actcoverage").html(data.actcoverage[0]+"/"+data.actcoverage[1]+" ("+data.actcoverage[2]+"%)"),$(".newcoverage").html(data.newcoverage[0]+"/"+data.newcoverage[1]+" ("+data.newcoverage[2]+"%)"),!error},Gradedist.prototype.initChart=function(initdata,letters){str.get_strings([{key:"gradeletter",component:"gradereport_gradedist"},{key:"absolut",component:"gradereport_gradedist"},{key:"percent",component:"gradereport_gradedist"},{key:"printchart",component:"gradereport_gradedist"},{key:"downloadpng",component:"gradereport_gradedist"},{key:"downloadjpeg",component:"gradereport_gradedist"},{key:"downloadpdf",component:"gradereport_gradedist"},{key:"downloadsvg",component:"gradereport_gradedist"},{key:"downloadjpeg",component:"gradereport_gradedist"},{key:"contextbuttontitle",component:"gradereport_gradedist"}]).done((function(s){window.chart=new window.Chart($("#chart_container"),{type:"bar",data:{labels:letters,datasets:[{data:window.absolut,backgroundColor:"#990000",borderWidth:1},{data:window.absolutnew,backgroundColor:"#33cc33",borderWidth:1}]},options:{title:{display:!0,text:[initdata.title,""],fontSize:18,fontStyle:"normal"},scales:{yAxes:[{ticks:{beginAtZero:!0,padding:10},scaleLabel:{display:!0,labelString:s[1],fontColor:"#4d759e",fontSize:15},gridLines:{drawBorder:!1,lineWidth:.3,color:"#000000",zeroLineColor:"#c0e0d0"}}],xAxes:[{scaleLabel:{display:!0,labelString:s[0],fontColor:"#4d759e",fontSize:15},gridLines:{drawOnChartArea:!1},barPercentage:.8}]},legend:{display:!1},plugins:{datalabels:{anchor:"end",align:"top",color:"#000000"}}}})}))};var instance=new Gradedist;return instance.initializer=function(config){log.info("Initialize settings JS","gradedist"),require(["canvastoBlob"]);var initdata=config.data;window.mode=0;var letters=initdata.letters;window.absolut=[],window.percent=[],window.absolutnew=[],window.percentnew=[];window.submit=$("#id_submitbutton"),window.submit.length&&window.submit.prop("disabled",!0),$.map(letters,(function(letter){window.absolut.push(initdata.actdist[letter].count),window.percent.push(initdata.actdist[letter].percentage),window.absolutnew.push(initdata.newdist[letter].count),window.percentnew.push(initdata.newdist[letter].percentage)})),window.chart=[],require(["ChartDataLabels"],(function(){window.Chart.plugins.register({beforeDraw:function(chartInstance){var ctx=chartInstance.chart.ctx;ctx.fillStyle="white",ctx.fillRect(0,0,chartInstance.chart.width,chartInstance.chart.height)}}),instance.initChart(initdata,letters)}));var cfg={method:"POST",headers:{"Content-Type":"application/x-www-form-urlencoded; charset=UTF-8"},complete:function(arg1){instance.update(arg1)},url:M.cfg.wwwroot+"/grade/report/gradedist/ajax_handler.php?id="+initdata.courseid};$("#id_gradeitem").first().change(instance,(function(){var success=$(".alert-success");success&&success.remove(),cfg.data=$("#letterform").serialize()+"&updateall=1",$.ajax(cfg)}));var coursegroups=$("#id_coursegroup").first();coursegroups&&coursegroups.change(instance,(function(){var success=$(".alert-success");success&&success.remove(),$("#id_coursegrouping").first().prop("value","0"),cfg.data=$("#letterform").serialize()+"&updateall=1",$.ajax(cfg)}));var coursegroupings=$("#id_coursegrouping").first();coursegroupings&&coursegroupings.change(instance,(function(){var success=$(".alert-success");success&&success.remove(),$("#id_coursegroup").first().prop("value","0"),cfg.data=$("#letterform").serialize()+"&updateall=1",$.ajax(cfg)})),window.boundaries=$(".gradeboundaries_new input[type=text], #fgroup_id_grp_gradeboundaries_new input[type=text]"),window.boundaries.change(instance,(function(){var notifications=$("#page-grade-report-gradedist-index .notifyproblem, #page-grade-report-gradedist-index .notifysuccess");notifications&&notifications.remove();var success=$(".alert-success");success&&success.remove(),instance.validate()&&(cfg.data=$("#letterform").serialize()+"&updateall=1",$.ajax(cfg))})),$('input[name^="grp_description"]').change(instance,(function(){var values,values_new,s_y,ext_y;window.mode=this.value,1==window.mode?(values=window.percent,values_new=window.percentnew,s_y="percent",ext_y=100):(values=window.absolut,values_new=window.absolutnew,s_y="absolut",ext_y=Math.max(Math.max.apply(this,window.absolut),Math.max.apply(this,window.absolutnew))),str.get_string(s_y,"gradereport_gradedist").done((function(s){window.chart.options.scales.yAxes[0].scaleLabel.labelString=s,window.chart.options.scales.yAxes[0].ticks.suggestedMax=ext_y,window.chart.data.datasets[0].data=values,window.chart.data.datasets[1].data=values_new,window.chart.update()}))})),$("#id_grp_columns_actualcolumns, #id_grp_columns_newcolumns").click(instance,(function(){var column="id_grp_columns_actualcolumns"===this.id?0:1;this.checked?(window.chart.data.datasets[column].hidden=!1,window.chart.update()):(window.chart.data.datasets[column].hidden=!0,window.chart.update())}));var toprint=$(".grgd_print"),$printframe=$("#printframe");toprint.click(instance,(function(){var content='<!DOCTYPE html><html><head><title></title><script><\/script></head><body onload=""><img src="'+document.getElementById("chart_container").toDataURL("image/png")+'" style="width: 100%;" /></body></html>';$printframe[0].contentWindow.document.write(content),setTimeout((function(){$printframe[0].contentWindow.print()}),200)})),$(".grgd_pdf").click(instance,(function(){require(["html2pdf"],(function(html2pdf){var container=document.getElementById("chart_container"),positionInfo=container.getBoundingClientRect(),contheight=positionInfo.height;html2pdf(container,{margin:1,filename:"chart.pdf",image:{type:"png"},pagebreak:{mode:"avoid-all"},html2canvas:{backgroundColor:"#ffffff"},jsPDF:{unit:"px",format:[positionInfo.width,1.1*contheight],orientation:"landscape"}})}))})),$(".grgd_png").click(instance,(function(){require(["filesaver"],(function(saveAs){$("#chart_container").get(0).toBlob((function(blob){saveAs(blob,"chart.png")}))}))})),$(".grgd_jpg").click(instance,(function(){require(["filesaver"],(function(saveAs){$("#chart_container").get(0).toBlob((function(blob){saveAs(blob,"chart.jpg")}),"image/jpeg")}))})),$('#letterform input[type="submit"]').click((function(){setTimeout((function(){instance.validate()}),1e3)})),instance.validate()},instance}));

//# sourceMappingURL=gradedist.min.js.map