<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Infraction
 *
 * @package    local_academic_integrity
 * @copyright  2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once(dirname(__FILE__, 3) . '/config.php');

use \local_academic_integrity\infraction;
use \local_academic_integrity\shared_lib as NED;

$id        = optional_param(NED::PAR_ID, 0, PARAM_INT);
$studentid = optional_param(NED::PAR_USER, 0, PARAM_INT);
$courseid  = optional_param(NED::PAR_COURSE, 0, PARAM_INT);
$cmid      = optional_param(NED::PAR_CM, 0, PARAM_INT);
$returnurl = optional_param(NED::PAR_RETURN_URL, '', PARAM_LOCALURL);

$params = [NED::PAR_ID => $id, NED::PAR_USER => $studentid, NED::PAR_COURSE => $courseid, NED::PAR_CM => $cmid, NED::PAR_RETURN_URL => $returnurl];
list($thispageurl, $redirecturl) = NED::setup_ai_page($params, 'addedit');

$instance = null;

if (!empty($id)) {
    $infraction = new \local_academic_integrity\infraction($id);
    $infraction->show_error_if_can_not_edit();

    $instance = $infraction->instance;
    $toform = $instance;
    $params[NED::PAR_USER] = $instance->student;
    $params[NED::PAR_COURSE] = $instance->courseid;
    $params[NED::PAR_CM] = $instance->cmid;
} elseif (!empty($studentid)){
    \local_academic_integrity\infraction::show_error_if_can_not_add_aiv($studentid);

    $toform = new stdClass();
    $toform->id = 0;
    $toform->student = $studentid;
} else {
    throw new \coding_exception('Unexpected id');
}
$toform->returnurl = $returnurl ?: NED::PAGE_AI_INFRACTIONS;

$mform = new \local_academic_integrity\form\infraction_form($thispageurl, $params);

// File upload preperation.
$contextsystem = context_system::instance();
$draftitemid = file_get_submitted_draft_itemid('uploadedfiles');
file_prepare_draft_area($draftitemid, $contextsystem->id, 'local_academic_integrity', 'uploadedfiles', $toform->id, $mform->upload_file_options());
$toform->uploadedfiles = $draftitemid;

if ($mform->is_cancelled()) {
    redirect($redirecturl);
} elseif ($mform->is_submitted() && $mform->is_validated()) {
    if ($mform->save_data()){
        redirect($redirecturl);
        exit;
    }
}

NED::js_call_amd('infraction_edit');
echo $OUTPUT->header();
$mform->set_data($toform);
$mform->display();
echo $OUTPUT->footer();