<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Infraction Delete
 *
 * @package    local_academic_integrity
 * @copyright  2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_academic_integrity\shared_lib as NED;

require_once(dirname(__FILE__, 3) . '/config.php');

$id        = optional_param(NED::PAR_ID, 0, PARAM_INT);
$courseid  = optional_param(NED::PAR_COURSE, 0, PARAM_INT);
$returnurl = optional_param(NED::PAR_RETURN_URL, '', PARAM_LOCALURL);
$process   = optional_param('process', 0, PARAM_INT);

$pageparams = [NED::PAR_ID => $id, NED::PAR_COURSE => $courseid, NED::PAR_RETURN_URL => $returnurl];
list($thispageurl, $redirecturl) = NED::setup_ai_page($pageparams, get_string('delete'), '~/infraction_delete.php');

$infraction = new \local_academic_integrity\infraction($id);
$infraction->show_error_if_can_not_edit();

if ($process){
    if ($infraction->delete()){
        NED::notification_add('successfullyremovedinfraction', NED::NOTIFY_SUCCESS);
        if ($redirecturl->compare($thispageurl, URL_MATCH_BASE)){
            unset($pageparams[NED::PAR_ID]);
            unset($pageparams[NED::PAR_RETURN_URL]);
            $redirecturl = NED::url(NED::PAGE_AI_INFRACTIONS, $pageparams);
        }
        redirect($redirecturl);
        die;
    }
}

echo $OUTPUT->header();

$grade_record = NED::$ned_grade_controller::get_record_by_related_id($id);
if ($grade_record){
    echo NED::html_p(NED::str('deleteconnectedrecord'), 'alert alert-warning');
    echo NED::html_p(NED::link([NED::PAGE_GRADE_CONTROLLER, [NED::PAR_FILTER_ID => $grade_record->id]],
        NED::$C::str('opensomepage', NED::$C::str('gradecontroller'))));
}

$continue = clone $thispageurl;
$continue->param('process', 1);

$data = (object)[
    'student' => $infraction->student,
    'penalty' => $infraction->penalty,
    'reason' => $infraction->reason,
    'infractiondate' => $infraction->infractiondate,
];
$infraction->set_get_raw_data();
NED::save_author_and_editor_to_obj($infraction,$data);
$message = NED::render_from_template('infraction_delete_confirm', $data);

echo $OUTPUT->confirm($message, $continue, $redirecturl);

echo $OUTPUT->footer();
