<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Infraction
 *
 * @package    local_academic_integrity
 * @copyright  2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use \local_academic_integrity\shared_lib as NED;

require_once(dirname(__FILE__, 3) . '/config.php');

$id           = optional_param(NED::PAR_ID, 0, PARAM_INT);
$courseid     = optional_param(NED::PAR_COURSE, null, PARAM_INT);
$course_view  = optional_param(NED::PAR_COURSE_VIEW, true, PARAM_BOOL);
$returnurl    = optional_param(NED::PAR_RETURN_URL, '', PARAM_LOCALURL);

$infraction = new \local_academic_integrity\infraction($id);
$infraction->show_error_if_can_not_view();

if ($course_view){
    if (is_null($courseid) || ($courseid && $courseid != $infraction->instance->courseid)){
        $courseid = $infraction->instance->courseid;
    }
    if (!NED::course_can_view_course_info($courseid)){
        $course_view = false;
    }
}

$ctx = NED::ctx($course_view ? $courseid : null);
$pageparams = [NED::PAR_ID => $id, NED::PAR_COURSE => $courseid, NED::PAR_COURSE_VIEW => $course_view, NED::PAR_RETURN_URL => $returnurl];
list($thispageurl, $redirecturl) = NED::setup_ai_page($pageparams, get_string('view'), NED::PAGE_AI_VIEW, $ctx, true);

$infraction_view = new local_academic_integrity\output\infraction_view($id, $courseid, $redirecturl, $ctx);

echo $OUTPUT->header();
echo NED::render($infraction_view);
echo $OUTPUT->footer();