<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package   local_academic_integrity
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['pluginname'] = 'Academic Violations';
$string['academic_integrity:viewownschool'] = 'View AV flags for own school';
$string['academic_integrity:viewallschools'] = 'View AV flags for all schools';
$string['academic_integrity:addviolations'] = 'Create new Academic Violation Record (AVR)';
$string['academic_integrity:manageviolations'] = 'Manage Academic Violation Records (AVRs)';
$string['academic_integrity:viewunapproved'] = 'View hidden and unapproved AVRs';
$string['academic_integrity:changestate'] = 'Change AVR status';
$string['local_academic_integrity_showacademicintegrityflags'] = 'Enable Academic Violation Flags';
$string['local_academic_integrity_showacademicintegrityflags_description'] = 'Show students\' Academic Violation Flags';
$string['local_academic_integrity_showflagtostudent'] = 'Show Academic Violation Flags to students';
$string['local_academic_integrity_showflagtostudent_description'] = 'Show students their own Academic Violation Flags';
$string['local_academic_integrity_title'] = 'Academic Violations: {$a}';
$string['infraction'] = 'Infraction';
$string['addnewinfraction'] = 'Add new infraction';
$string['other'] = 'Other';
$string['resolved'] = 'Resolved';
$string['assignment'] = 'Assignment';
$string['unittest'] = 'Unit test';
$string['exam'] = 'Exam';
$string['academicintegrityinfraction'] = 'Academic Violation';
$string['academicintegrityinfractions'] = 'Academic Violations';
$string['rowcount'] = '';
$string['infractiondate'] = 'Date';
$string['school'] = 'School';
$string['export'] = 'Export';
$string['courseid'] = $string['course'] = 'Course';
$string['grader'] = 'Grader';
$string['student'] = 'Student';
$string['cmid'] = $string['activity'] = 'Activity';
$string['activitycode'] = 'Activity Code';
$string['activitytype'] = 'Activity Type';
$string['status'] = 'Status';
$string['state'] = 'Status';
$string['note'] = 'Note';
$string['infraction_note_desc'] = 'Remember to describe the AV in a professional manner, as all CTs will have access to these notes. '.
    'Please include specific details (i.e. which questions) and evidence files whenever possible.';
$string['infractiondescription'] = 'Description of Violation';
$string['addedit'] = 'Add/Edit';
$string['dateofinfraction'] = 'Date of Infraction';
$string['saveandclose'] = 'Save and Close';
$string['pleaseselect'] = 'Please Select';
$string['reason'] = 'Reason';
$string['penalty'] = 'Penalty';
$string['penalty:error'] = 'Penalty is already exists, and its type can\'t be changed';
$string['penalty_desc_link'] = 'Grading Guide';
$string['penalty_desc_href'] =
    "http://cloud.rosedaleacademy.com/repository/GHS-Docs/GHS%20Grading%20Teacher%20Docs/Policy%20Guide%20for%20Grading%20Teachers.pdf";
$string['penalty_desc_a'] = "<a href='{$string['penalty_desc_href']}' target='_blank'>{$string['penalty_desc_link']}</a>";
$string['penalty_desc'] =
    "<span>Please refer to the {$string['penalty_desc_a']} for information about selecting the proper penalty and reason.</span>";
$string['ct'] = $string['ctid'] = 'CT';
$string['action'] = 'Action';
$string['showall'] = 'Show all';
$string['filter'] = 'Filter';
$string['reset'] = 'Reset';
$string['downloadcsv'] = 'Download CSV';
$string['uploadedfiles'] = 'Uploaded files';
$string['deleteconnectedrecord'] = "Warning: it's connected to another penalty record.";
$string['addzeroawardedrecord'] = 'Add Zero awarded record';
$string['successfullysavedinfraction'] = 'Successfully saved AVR';
$string['successfullyremovedinfraction'] = 'Successfully removed AVR';
$string['successfullysave_ngc'] = 'Successfully saved Grade Penalty record';
$string['failedsavedaz'] = 'Failed to save Award Zero record';
$string['aivwaitingforapproval'] = 'AVR waiting for approval';

// new infractions
$string['minorplagiarism'] = 'Minor plagiarism – 20% deduction';
$string['majorplagiarism'] = 'Major plagiarism – Zero grade';
$string['cheating'] = 'Cheating during a test or exam – Zero grade';
// reasons
$string['inf:reason:assign:internet']   = 'Assignment: Plagiarism from Internet';
$string['inf:reason:assign:student']    = 'Assignment: Plagiarism from other student';
$string['inf:reason:assign:self']       = 'Assignment: Plagiarism from self (previous work)';
$string['inf:reason:assign:citations']  = 'Assignment: Missing or improper citations';
$string['inf:reason:assign:genai']      = 'Assignment: Use of Generative Artificial Intelligence';
$string['inf:reason:exam:internet']     = 'Test/Exam: Copied from Internet';
$string['inf:reason:exam:student']      = 'Test/Exam: Similar response to another student';
$string['inf:reason:exam:aids']         = 'Test/Exam: Use of unauthorized aids';
$string['inf:reason:exam:not_supported']= 'Test/Exam: Final answer is not supported with process';
$string['inf:reason:exam:not_match']    = 'Test/Exam: Response does not match assigned question';
$string['inf:reason:other']             = 'Other';
// states
$string['inf:state:unapproved'] = 'Waiting for approval';
$string['inf:state:active'] = 'Visible + Penalty is applied';
$string['inf:state:pause_show'] = 'Visible + Penalty is not applied';
$string['inf:state:pause_hide'] = 'Not visible + Penalty is not applied';
// AI statuses - lang keys are also css classes
$string['ai-none'] = '';
$string['ai-good-standing'] = 'Good Standing';
$string['ai-first-offense'] = 'First offense';
$string['ai-multiple-offenses'] = 'Multiple offenses';

$string['transferstudent'] = 'Transfer student';
